/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.util;

import java.util.Observable;
import java.util.Observer;

public class GrayCode
extends Observable {
    private int maxsize = 0;
    private int size = 0;
    private final int[] n;
    private final int[] g;
    private final int[] u;
    private final int[] c;

    public GrayCode(int N, int k) {
        this.n = new int[k + 1];
        this.g = new int[k + 1];
        this.u = new int[k + 1];
        this.c = new int[k];
        for (int i = 0; i <= k; ++i) {
            this.g[i] = 0;
            this.u[i] = 1;
            this.n[i] = N;
        }
        this.size = 0;
    }

    public GrayCode(int[] N) {
        int k = N.length;
        this.n = new int[k + 1];
        this.g = new int[k + 1];
        this.u = new int[k + 1];
        this.c = new int[k];
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < k; ++i) {
            this.g[i] = 0;
            this.u[i] = 1;
            this.n[i] = N[i];
            if (N[i] >= min) continue;
            min = N[i];
        }
        this.g[k] = 0;
        this.u[k] = 1;
        this.n[k] = min;
        this.size = 0;
    }

    public void generate() {
        while (this.g[this.c.length] == 0) {
            System.arraycopy(this.g, 0, this.c, 0, this.c.length);
            this.setChanged();
            this.notifyObservers(this.c);
            int i = 0;
            int j = this.g[0] + this.u[0];
            while ((j >= this.n[i] || j < 0) && i < this.c.length) {
                this.u[i] = -this.u[i];
                j = this.g[++i] + this.u[i];
            }
            this.g[i] = j;
            ++this.size;
            if (this.countObservers() != 0 && (this.maxsize <= 0 || this.size < this.maxsize)) continue;
            break;
        }
    }

    public void setMaxSize(int maxsize) {
        this.maxsize = maxsize;
    }

    public int getMaxSize() {
        return this.maxsize;
    }

    public int size() {
        return this.size;
    }

    public static GrayCode createBinaryGrayCode(int size) {
        return new GrayCode(2, size);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length == 0) {
            System.out.println("Usage: GrayCode [N k | n0 n1...]\n");
            System.exit(1);
        }
        int[] a = new int[argv.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = Integer.parseInt(argv[i]);
        }
        GrayCode g = new GrayCode(a);
        g.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                int[] c = (int[])arg;
                System.out.print(c[0]);
                for (int i = 1; i < c.length; ++i) {
                    System.out.print(" " + c[i]);
                }
                System.out.println();
            }
        });
        g.generate();
        System.out.println("** " + g.size() + " values generated!");
    }

    public static class Enum {
        public static void main(final String[] argv) throws Exception {
            GrayCode g = GrayCode.createBinaryGrayCode(argv.length);
            g.addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    int[] c = (int[])arg;
                    int j = 0;
                    for (int i = 0; i < c.length; ++i) {
                        if (c[i] == 0) continue;
                        if (j == 0) {
                            System.out.print("[");
                        } else if (j > 0) {
                            System.out.print(",");
                        }
                        System.out.print(argv[i]);
                        ++j;
                    }
                    if (j > 0) {
                        System.out.println("]");
                    }
                }
            });
            g.generate();
        }
    }
}

