/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.util;

import gov.nih.ncats.common.sneak.Sneak;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class CachedSupplier<T>
implements Supplier<T>,
Callable<T> {
    private static AtomicLong generatedVersion = new AtomicLong();
    private final Supplier<T> c;
    private T cache;
    private AtomicBoolean run = new AtomicBoolean(false);
    private long generatedWithVersion;

    public static void resetAllCaches() {
        generatedVersion.incrementAndGet();
    }

    public CachedSupplier(Supplier<T> c) {
        this.c = Objects.requireNonNull(c);
    }

    @Override
    public T call() throws Exception {
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.hasRun()) {
            return this.cache;
        }
        CachedSupplier cachedSupplier = this;
        synchronized (cachedSupplier) {
            if (this.hasRun()) {
                return this.cache;
            }
            this.generatedWithVersion = generatedVersion.get();
            this.cache = this.directCall();
            this.run.set(true);
            return this.cache;
        }
    }

    protected T directCall() {
        return this.c.get();
    }

    public synchronized T getSync() {
        return this.get();
    }

    public boolean hasRun() {
        return this.run.get() && !this.cacheHasBeenReset();
    }

    protected boolean cacheHasBeenReset() {
        return this.generatedWithVersion != generatedVersion.get();
    }

    public void resetCache() {
        this.run.set(false);
    }

    public static <T> CachedSupplier<T> runOnce(Supplier<T> supplier) {
        return new UnResettableCachedSupplier<T>(supplier);
    }

    public static <T> CachedSupplier<T> runOnceCallable(Callable<T> callable) {
        return CachedSupplier.runOnce(() -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public static <T> CachedSupplier<T> of(Supplier<T> supplier) {
        return new CachedSupplier<T>(supplier);
    }

    public static <T> CachedSupplier<T> ofCallable(Callable<T> callable) {
        return CachedSupplier.of(() -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public static <T> CachedThrowingSupplier<T> ofThrowing(Callable<T> callable) {
        return CachedThrowingSupplier.createFromSupplier(() -> {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                Sneak.sneakyThrow(e);
                return null;
            }
        });
    }

    private static class UnResettableCachedSupplier<T>
    extends CachedSupplier<T> {
        public UnResettableCachedSupplier(Supplier<T> c) {
            super(c);
        }

        @Override
        protected boolean cacheHasBeenReset() {
            return false;
        }

        @Override
        public void resetCache() {
        }
    }

    public static class CachedThrowingSupplier<T>
    extends CachedSupplier<Optional<T>> {
        public Throwable thrown = null;

        public static <T> CachedThrowingSupplier<T> createFromSupplier(Supplier<T> consumer) {
            return new CachedThrowingSupplier<T>(() -> Optional.ofNullable(consumer.get()));
        }

        public static <T> CachedThrowingSupplier<T> createFromSupplierOfOptionals(Supplier<Optional<T>> consumer) {
            return new CachedThrowingSupplier<T>(consumer);
        }

        private CachedThrowingSupplier(Supplier<Optional<T>> c) {
            super(c);
        }

        @Override
        protected Optional<T> directCall() {
            try {
                return (Optional)super.directCall();
            }
            catch (Throwable e) {
                this.setThrown(e);
                return Optional.empty();
            }
        }

        private void setThrown(Throwable t) {
            this.thrown = t;
        }

        public Optional<Throwable> getThrown() {
            this.get();
            return Optional.ofNullable(this.thrown);
        }
    }
}

