/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;

public class BinaryGrayCode {
    private final List<BitSet> list;

    public BinaryGrayCode(int numBits) {
        if (numBits < 1) {
            throw new IllegalArgumentException("num Bits must be >=1");
        }
        this.list = new LinkedList<BitSet>();
        BitSet b = new BitSet(numBits);
        b.set(numBits - 1);
        this.list.add(new BitSet(numBits));
        this.list.add(b);
        for (int i = numBits - 2; i >= 0; --i) {
            ArrayList<BitSet> reflected = new ArrayList<BitSet>(this.list.size());
            ListIterator<BitSet> iter = this.list.listIterator(this.list.size());
            while (iter.hasPrevious()) {
                BitSet clone = (BitSet)iter.previous().clone();
                clone.set(i);
                reflected.add(clone);
            }
            this.list.addAll(reflected);
        }
    }

    public void traverse(Consumer<BitSet> consumer) {
        Objects.requireNonNull(consumer);
        for (BitSet bs : this.list) {
            consumer.accept((BitSet)bs.clone());
        }
    }

    public static void main(String[] args) {
        new BinaryGrayCode(3).traverse(bs -> System.out.println(BinaryGrayCode.createPaddedToString(bs)));
    }

    private static String createPaddedToString(BitSet bs) {
        int i;
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < bs.length(); ++i) {
            if (bs.get(i)) {
                builder.append('1');
                continue;
            }
            builder.append('0');
        }
        for (i = bs.length(); i < 3; ++i) {
            builder.append('0');
        }
        return builder.toString();
    }
}

