/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.stream;

import gov.nih.ncats.common.stream.ThrowingStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

class ThrowingStreamImpl<T>
implements ThrowingStream<T> {
    private final Stream<T> delegate;

    public ThrowingStreamImpl(Stream<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public ThrowingStream<T> filter(Predicate<? super T> predicate) {
        return this.handleNewStream(() -> this.delegate.filter(predicate));
    }

    @Override
    public <R> ThrowingStream<R> map(Function<? super T, ? extends R> mapper) {
        return ThrowingStream.asThrowingStream(this.delegate.map(mapper));
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.delegate.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.delegate.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.delegate.mapToDouble(mapper);
    }

    @Override
    public <R> ThrowingStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return ThrowingStream.asThrowingStream(this.delegate.flatMap(mapper));
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.delegate.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.delegate.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.delegate.flatMapToDouble(mapper);
    }

    @Override
    public ThrowingStream<T> distinct() {
        return this.handleNewStream(this.delegate::distinct);
    }

    @Override
    public ThrowingStream<T> sorted() {
        return this.handleNewStream(this.delegate::sorted);
    }

    @Override
    public ThrowingStream<T> sorted(Comparator<? super T> comparator) {
        return this.handleNewStream(() -> this.delegate.sorted(comparator));
    }

    @Override
    public ThrowingStream<T> peek(Consumer<? super T> action) {
        return this.handleNewStream(() -> this.delegate.peek(action));
    }

    @Override
    public ThrowingStream<T> limit(long maxSize) {
        return this.handleNewStream(() -> this.delegate.limit(maxSize));
    }

    @Override
    public ThrowingStream<T> skip(long n) {
        return this.handleNewStream(() -> this.delegate.skip(n));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.delegate.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.delegate.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.delegate.toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.delegate.reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.delegate.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.delegate.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.delegate.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.delegate.collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.delegate.min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.delegate.max(comparator);
    }

    @Override
    public long count() {
        return this.delegate.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.delegate.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.delegate.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.delegate.noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.delegate.findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.delegate.findAny();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.delegate.isParallel();
    }

    @Override
    public ThrowingStream<T> sequential() {
        return this.handleNewStream(this.delegate::sequential);
    }

    @Override
    public ThrowingStream<T> parallel() {
        return this.handleNewStream(this.delegate::parallel);
    }

    @Override
    public ThrowingStream<T> unordered() {
        return this.handleNewStream(this.delegate::unordered);
    }

    @Override
    public ThrowingStream<T> onClose(Runnable closeHandler) {
        Stream newStream = (Stream)this.delegate.onClose(closeHandler);
        if (newStream == this.delegate) {
            return this;
        }
        return ThrowingStream.asThrowingStream(newStream);
    }

    private ThrowingStream<T> handleNewStream(Supplier<Stream<T>> supplier) {
        Stream<T> newStream = supplier.get();
        if (newStream == this.delegate) {
            return this;
        }
        return ThrowingStream.asThrowingStream(newStream);
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

