/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.stream;

import gov.nih.ncats.common.functions.ThrowableConsumer;
import gov.nih.ncats.common.sneak.Sneak;
import gov.nih.ncats.common.stream.ThrowingStreamImpl;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ThrowingStream<T>
extends Stream<T> {
    public static <T> ThrowingStream<T> asThrowingStream(Stream<T> stream) {
        return new ThrowingStreamImpl<T>(stream);
    }

    default public <E extends Exception> void throwingForEach(ThrowableConsumer<? super T, E> action) throws E {
        this.forEach(t -> {
            try {
                action.accept(t);
            }
            catch (Throwable ex) {
                throw Sneak.sneakyThrow(ex);
            }
        });
    }

    default public <E extends Exception> void throwingForEachOrdered(ThrowableConsumer<? super T, E> action) throws E {
        this.forEachOrdered(t -> {
            try {
                action.accept(t);
            }
            catch (Throwable ex) {
                throw Sneak.sneakyThrow(ex);
            }
        });
    }

    @Override
    public ThrowingStream<T> sequential();

    @Override
    public ThrowingStream<T> parallel();

    @Override
    public ThrowingStream<T> unordered();

    @Override
    public ThrowingStream<T> onClose(Runnable var1);

    @Override
    public ThrowingStream<T> filter(Predicate<? super T> var1);

    @Override
    public <R> ThrowingStream<R> map(Function<? super T, ? extends R> var1);

    @Override
    public <R> ThrowingStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    @Override
    public ThrowingStream<T> distinct();

    @Override
    public ThrowingStream<T> sorted();

    @Override
    public ThrowingStream<T> sorted(Comparator<? super T> var1);

    @Override
    public ThrowingStream<T> peek(Consumer<? super T> var1);

    @Override
    public ThrowingStream<T> limit(long var1);

    @Override
    public ThrowingStream<T> skip(long var1);

    public static <T> ThrowingStream<T> createFrom(Spliterator<T> spliterator, boolean parallel) {
        return ThrowingStream.asThrowingStream(StreamSupport.stream(spliterator, parallel));
    }
}

