/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.stream;

import gov.nih.ncats.common.util.CachedSupplier;
import gov.nih.ncats.common.util.Unchecked;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtil {
    public static <T> Stream<T> forIterator(Iterator<T> it) {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1024), false).onClose(() -> {
            if (it instanceof Closeable) {
                Unchecked.ioException(() -> ((Closeable)((Object)it)).close());
            }
        });
    }

    public static <T> Stream<T> forGenerator(final Supplier<Optional<T>> sup) {
        Iterator ir = new Iterator<T>(){
            public CachedSupplier<Optional<T>> next;
            public boolean initialized = false;

            @Override
            public synchronized boolean hasNext() {
                if (!this.initialized) {
                    this.initialize();
                }
                return this.next.get().isPresent();
            }

            @Override
            public synchronized T next() {
                if (!this.initialized) {
                    this.initialize();
                }
                Optional n = this.next.get();
                this.cacheNext();
                return n.get();
            }

            public synchronized void cacheNext() {
                this.next.resetCache();
            }

            private void initialize() {
                this.next = CachedSupplier.of(sup);
                this.initialized = true;
            }
        };
        return StreamUtil.forIterator(ir);
    }

    public static <T> Stream<T> forNullableGenerator(Supplier<T> sup) {
        return StreamUtil.forGenerator(() -> Optional.ofNullable(sup.get()));
    }

    public static <T> Stream<T> forIterable(Iterable<T> sup) {
        return StreamSupport.stream(sup.spliterator(), false);
    }

    private static <K, T> Stream<T> forNullableGenerator(K k, Function<K, T> sup) {
        return StreamUtil.forNullableGenerator(() -> sup.apply(k));
    }

    public static <K> StreamGenerator<K> from(K k) {
        return new StreamGenerator(k);
    }

    public static <T> StreamConcatter<T> with(Stream<T> s) {
        return new StreamConcatter<T>().and(s);
    }

    public static <T> Stream<T> cycle(T ... elements) {
        return Stream.generate(RolloverIterator.create(elements)::next);
    }

    public static Stream<String> lines(String text) {
        return Arrays.stream(text.split("\n"));
    }

    public static <T> Supplier<T> supplierFor(Stream<T> stream) {
        Iterator it = stream.iterator();
        Supplier<Object> sup = () -> {
            Iterator iterator = it;
            synchronized (iterator) {
                if (it.hasNext()) {
                    return it.next();
                }
            }
            return null;
        };
        return sup;
    }

    public static <T> Stream<T> forEnumeration(Enumeration<T> enumeration) {
        return StreamUtil.forNullableGenerator(() -> enumeration.hasMoreElements() ? enumeration.nextElement() : null);
    }

    public static <T> Collector<T, ?, Stream<T>> maxElements(int n, Comparator<T> comp) {
        return new ReducedCollector(n, comp);
    }

    private static class TopNReducer<T> {
        private final PriorityQueue<T> pq;
        private final Comparator<T> comp;
        private final int cap;
        private final int effcap;
        private int _buff = 0;

        public TopNReducer(int n, Comparator<T> comp) {
            this.comp = comp;
            this.pq = new PriorityQueue(n, (a, b) -> -comp.compare(a, b));
            this.cap = n;
            this.effcap = this.cap * 1;
        }

        public void add(T t) {
            this.pq.add(t);
            ++this._buff;
            if (this._buff > this.effcap) {
                int r = this._buff - this.cap;
                for (int i = 0; i < r; ++i) {
                    this.pq.remove();
                }
                this._buff = this.cap;
            }
        }

        public Stream<T> get() {
            return this.pq.stream().sorted(this.comp).limit(this.cap);
        }
    }

    public static class ReducedCollector<T>
    implements Collector<T, TopNReducer<T>, Stream<T>> {
        private final Comparator<T> comp;
        private final int max;

        private ReducedCollector(int max, Comparator<T> comp) {
            this.comp = comp;
            this.max = max;
        }

        @Override
        public Supplier<TopNReducer<T>> supplier() {
            return () -> new TopNReducer<T>(this.max, this.comp);
        }

        @Override
        public BiConsumer<TopNReducer<T>, T> accumulator() {
            return (red, t) -> red.add(t);
        }

        @Override
        public BinaryOperator<TopNReducer<T>> combiner() {
            return (a, b) -> {
                b.get().forEach(t -> a.add(t));
                return a;
            };
        }

        @Override
        public Function<TopNReducer<T>, Stream<T>> finisher() {
            return red -> red.get();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return new HashSet<Collector.Characteristics>();
        }
    }

    public static class StreamConcatter<T> {
        Stream<T> s = Stream.empty();

        private StreamConcatter() {
        }

        public StreamConcatter<T> and(Stream<T> newstream) {
            this.s = Stream.concat(this.s, newstream);
            return this;
        }

        public StreamConcatter<T> and(Collection<T> newCollection) {
            this.s = Stream.concat(this.s, newCollection.stream());
            return this;
        }

        public StreamConcatter<T> and(Iterable<T> newCollection) {
            this.s = Stream.concat(this.s, StreamUtil.forIterator(newCollection.iterator()));
            return this;
        }

        public StreamConcatter<T> and(T ... newThings) {
            this.s = Stream.concat(this.s, Stream.of(newThings));
            return this;
        }

        public Stream<T> stream() {
            return this.s;
        }
    }

    private static final class RolloverIterator<T> {
        private final T[] elements;
        int index = 0;

        private static <T> RolloverIterator<T> create(T[] elements) {
            return new RolloverIterator<T>(elements);
        }

        private RolloverIterator(T[] elements) {
            this.elements = elements;
        }

        public T next() {
            return this.elements[this.index++ % this.elements.length];
        }
    }

    public static class StreamGenerator<K> {
        private K k;

        private StreamGenerator(K k) {
            this.k = k;
        }

        public Stream<K> streamWhile(Predicate<K> next) {
            return (Stream)StreamUtil.forGenerator(() -> next.test(this.k) ? Optional.of(this.k) : Optional.empty()).sequential();
        }
    }
}

