/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.iter;

import gov.nih.ncats.common.iter.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

final class CloseableIteratorImpl {
    private CloseableIteratorImpl() {
    }

    public static <T, I extends Iterator<T> & Closeable> CloseableIterator<T> wrap(Iterator<T> iter) {
        Objects.requireNonNull(iter);
        if (iter instanceof Closeable) {
            if (iter instanceof CloseableIterator) {
                return (CloseableIterator)iter;
            }
            return new CloseableWrapper(iter);
        }
        return new Wrapper<T>(iter);
    }

    static final class CloseableWrapper<T, I extends Iterator<T> & Closeable>
    implements CloseableIterator<T> {
        private final I delegate;

        public CloseableWrapper(I iter) {
            this.delegate = iter;
        }

        @Override
        public void close() throws IOException {
            ((Closeable)this.delegate).close();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return (T)this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    static final class Wrapper<T>
    implements CloseableIterator<T> {
        private final Iterator<T> delegate;

        public Wrapper(Iterator<T> iter) {
            this.delegate = iter;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

