/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.io;

import gov.nih.ncats.common.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class MagicNumberInputStream
extends InputStream {
    private final InputStream in;
    private final byte[] magicNumber;
    private int numberOfBytesRead = 0;

    public MagicNumberInputStream(InputStream in) throws IOException {
        this(in, 4);
    }

    public MagicNumberInputStream(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file)), 4);
    }

    public MagicNumberInputStream(InputStream in, int sizeOfMagicNumber) throws IOException {
        this.magicNumber = IOUtil.toByteArray(in, sizeOfMagicNumber);
        this.in = in;
    }

    public byte[] peekMagicNumber() {
        return Arrays.copyOf(this.magicNumber, this.magicNumber.length);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.numberOfBytesRead < this.magicNumber.length) {
            return this.magicNumber[this.numberOfBytesRead++];
        }
        return this.in.read();
    }
}

