/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.io;

import gov.nih.ncats.common.io.BasicZipInputStreamSupplier;
import gov.nih.ncats.common.io.GZipInputStreamSupplier;
import gov.nih.ncats.common.io.IOUtil;
import gov.nih.ncats.common.io.MagicNumberInputStream;
import gov.nih.ncats.common.io.RawFileInputStreamSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

@FunctionalInterface
public interface InputStreamSupplier {
    public InputStream get() throws IOException;

    default public Optional<File> getFile() {
        return Optional.empty();
    }

    public static InputStreamSupplier forFile(File f) throws IOException {
        byte[] magicNumber;
        IOUtil.verifyIsReadable(f);
        if (f.length() == 0L) {
            return new RawFileInputStreamSupplier(f);
        }
        try (MagicNumberInputStream magicNumInputStream = new MagicNumberInputStream(f);){
            magicNumber = magicNumInputStream.peekMagicNumber();
        }
        if (magicNumber[0] == 80 && magicNumber[1] == 75 && magicNumber[2] == 3 && magicNumber[3] == 4) {
            return new BasicZipInputStreamSupplier(f);
        }
        if (magicNumber[0] == 31 && magicNumber[1] == -117) {
            return new GZipInputStreamSupplier(f);
        }
        return new RawFileInputStreamSupplier(f);
    }
}

