/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public final class IOUtil {
    private static final int EOF = -1;

    private IOUtil() {
    }

    public static void deleteRecursivelyQuitely(File dir) {
        try {
            IOUtil.deleteRecursively(dir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void printDirectoryStructure(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileVisitResult fvr = super.postVisitDirectory(dir, exc);
                File dirfile = dir.toFile();
                try {
                    System.out.println("Visiting  :" + dirfile.getAbsolutePath());
                }
                catch (Exception e) {
                    System.out.println("unable to visit:" + e.getMessage());
                }
                return fvr;
            }
        });
    }

    public static void mkdirs(File dir) throws IOException {
        if (dir == null) {
            return;
        }
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
    }

    public static void deleteRecursively(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!file.toFile().getName().startsWith(".nfs")) {
                    try {
                        Files.delete(file);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileVisitResult fvr = super.postVisitDirectory(dir, exc);
                File dirfile = dir.toFile();
                try {
                    Files.delete(dir);
                }
                catch (Exception e) {
                    System.out.println("unable to delete:" + e.getMessage());
                }
                return fvr;
            }
        });
    }

    public static void closeQuietly(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BufferedOutputStream newBufferedOutputStream(File outputFile) throws IOException {
        File parent = outputFile.getParentFile();
        if (parent != null) {
            Files.createDirectories(parent.toPath(), new FileAttribute[0]);
        }
        return new BufferedOutputStream(new FileOutputStream(outputFile));
    }

    public static void closeQuitely(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int numBytesRead;
        byte[] buf = new byte[2048];
        long numBytesCopied = 0L;
        while ((numBytesRead = in.read(buf)) != -1) {
            numBytesCopied += (long)numBytesRead;
            out.write(buf, 0, numBytesRead);
            out.flush();
        }
        return numBytesCopied;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(input, output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(InputStream in, int numberOfBytesToRead) throws IOException {
        byte[] array = new byte[numberOfBytesToRead];
        IOUtil.blockingRead(in, array, 0, numberOfBytesToRead);
        return array;
    }

    public static void blockingRead(InputStream in, byte[] buf) throws IOException {
        IOUtil.blockingRead(in, buf, 0, buf.length);
    }

    public static void blockingRead(InputStream in, byte[] buf, int offset, int length) throws IOException {
        IOUtil.checkBlockingReadInputsAreOK(in, buf, offset, length);
        int currentBytesRead = 0;
        int totalBytesRead = 0;
        while ((currentBytesRead = in.read(buf, offset + totalBytesRead, length - totalBytesRead)) > 0 && (totalBytesRead += currentBytesRead) != length) {
        }
        if (currentBytesRead == -1) {
            throw new EOFException(String.format("end of file after only %d bytes read (expected %d)", totalBytesRead, length));
        }
    }

    public static void verifyIsReadable(File f) throws IOException {
        if (f == null) {
            throw new NullPointerException("file can not be null");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("file must exist : " + f.getAbsolutePath());
        }
        if (!f.canRead()) {
            throw new IOException("file is not readable: " + f.getAbsolutePath());
        }
    }

    private static void checkBlockingReadInputsAreOK(InputStream in, byte[] buf, int offset, int length) {
        if (buf == null) {
            throw new NullPointerException("byte array can not be null");
        }
        if (in == null) {
            throw new NullPointerException("inputstream can not be null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be >= 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
    }
}

