/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.gov.nih.ncats.common.executors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BlockingSubmitExecutor
extends ThreadPoolExecutor {
    public static ExecutorService newFixedThreadPool(int numThreads, int blockingQueueCapacity) {
        return new BlockingSubmitExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, blockingQueueCapacity);
    }

    public static ExecutorService newThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int blockingQueueCapacity) {
        return new BlockingSubmitExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, blockingQueueCapacity);
    }

    private BlockingSubmitExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int blockingQueueCapacity) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new BlockingOfferQueue<Runnable>(blockingQueueCapacity));
    }

    private static final class BlockingOfferQueue<E>
    extends LinkedBlockingDeque<E> {
        public BlockingOfferQueue(int capacity) {
            super(capacity);
        }

        @Override
        public boolean offer(E e) {
            try {
                this.put(e);
                return true;
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }
}

