/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import gov.nih.ncats.common.functions.ThrowableBiConsumer;
import gov.nih.ncats.common.functions.ThrowableBiFunction;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Tuple<K, V> {
    private K k;
    private V v;

    public Tuple(K k, V v) {
        this.k = k;
        this.v = v;
    }

    @JsonProperty(value="key")
    public K k() {
        return this.k;
    }

    @JsonProperty(value="value")
    public V v() {
        return this.v;
    }

    public <E extends Throwable> void consume(ThrowableBiConsumer<K, V, E> consumer) throws E {
        consumer.accept(this.k, this.v);
    }

    public <T, E extends Throwable> T map(ThrowableBiFunction<K, V, T, E> biFunction) throws E {
        return biFunction.apply(this.k, this.v);
    }

    public static <K, V> Tuple<K, V> of(K k, V v) {
        return new Tuple<K, V>(k, v);
    }

    public Tuple<V, K> swap() {
        return Tuple.of(this.v(), this.k());
    }

    public static <K, V, U> Function<Tuple<K, V>, Tuple<K, U>> vmap(Function<V, U> fun) {
        return t -> Tuple.of(t.k(), fun.apply(t.v()));
    }

    public static <K, V, L> Function<Tuple<K, V>, Tuple<L, V>> kmap(Function<K, L> fun) {
        return t -> Tuple.of(fun.apply(t.k()), t.v());
    }

    public static <K, V> Tuple<K, V> of(Map.Entry<K, V> ent) {
        return Tuple.of(ent.getKey(), ent.getValue());
    }

    public static <K, V> BiFunction<K, V, Tuple<K, V>> map() {
        return (k, v) -> new Tuple<Object, Object>(k, v);
    }

    public static <T, U> Collector<Tuple<T, U>, ?, Map<T, U>> toMap() {
        return Collectors.toMap(Tuple::k, Tuple::v);
    }

    public static <T, U> Collector<Tuple<T, U>, ?, Map<T, List<U>>> toGroupedMap() {
        return Tuple.toGroupedMap(Collectors.toList());
    }

    public static <T, U, V> Collector<Tuple<T, U>, ?, Map<T, V>> toGroupedMap(Collector<U, ?, V> collect) {
        return Collectors.groupingBy(Tuple::k, Collectors.mapping(Tuple::v, collect));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tuple)) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        if (this.k != null ? !this.k.equals(tuple.k) : tuple.k != null) {
            return false;
        }
        return this.v != null ? this.v.equals(tuple.v) : tuple.v == null;
    }

    public int hashCode() {
        int result = this.k != null ? this.k.hashCode() : 0;
        result = 31 * result + (this.v != null ? this.v.hashCode() : 0);
        return result;
    }

    public static <K, V> Set<Tuple<K, V>> toTupleSet(Map<K, V> map) {
        return map.entrySet().stream().map(Tuple::of).collect(Collectors.toSet());
    }

    public String toString() {
        return "<" + this.k.toString() + "," + this.v.toString() + ">";
    }

    public static <K, V, T> Function<Tuple<K, V>, Stream<Tuple<K, T>>> vstream(Function<V, Stream<T>> smap) {
        return t -> ((Stream)smap.apply(t.v())).map((? super T v) -> Tuple.of(t.k(), v));
    }

    public static <K, V, T> Function<Tuple<K, V>, Stream<Tuple<T, V>>> kstream(Function<K, Stream<T>> smap) {
        return t -> ((Stream)smap.apply(t.k())).map((? super T k) -> Tuple.of(k, t.v()));
    }

    public ComparableTuple<K, V> asComparable(Comparator<Tuple<K, V>> comp) {
        return new ComparableTuple<K, V>(this, comp);
    }

    public ComparableTuple<K, V> withKSortOrder(Comparator<K> comp) {
        return new ComparableTuple(this, (a, b) -> comp.compare(a.k, b.k));
    }

    public <T extends Comparable<T>> ComparableTuple<K, V> withKSortOrder(Function<K, T> mapper) {
        return this.withKSortOrder((a, b) -> ((Comparable)mapper.apply(a)).compareTo(mapper.apply(b)));
    }

    public <T extends Comparable<T>> ComparableTuple<K, V> withKSortOrder() throws ComparatorNotImplementedException {
        if (this.k instanceof Comparable) {
            return this.withKSortOrder((K k1) -> (Comparable)k1);
        }
        if (this.k != null) {
            throw new ComparatorNotImplementedException("Cannot sort based on non-comparable type:" + this.k.getClass().getName());
        }
        throw new ComparatorNotImplementedException("Cannot sort based on null value");
    }

    public KEqualityTuple<K, V> withKEquality() {
        return new KEqualityTuple<K, V>(this.k, this.v);
    }

    public VEqualityTuple<K, V> withVEquality() {
        return new VEqualityTuple<K, V>(this.k, this.v);
    }

    public static class ComparableTuple<K, V>
    extends Tuple<K, V>
    implements Comparable<Tuple<K, V>> {
        private Tuple<K, V> delegate;
        private Comparator<Tuple<K, V>> com = null;

        public ComparableTuple(K k, V v, Comparator<Tuple<K, V>> comp) {
            this(Tuple.of(k, v), comp);
        }

        public ComparableTuple(Tuple<K, V> del, Comparator<Tuple<K, V>> comp) {
            super(((Tuple)del).k, ((Tuple)del).v);
            this.com = comp;
            this.delegate = del;
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public int compareTo(Tuple<K, V> arg0) {
            return this.com.compare(this, arg0);
        }
    }

    public static class VEqualityTuple<K, V>
    extends Tuple<K, V> {
        public VEqualityTuple(K k, V v) {
            super(k, v);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple other = (Tuple)o;
            return this.v().equals(other.v());
        }

        @Override
        public int hashCode() {
            if (this.k() == null) {
                return 0;
            }
            return this.k().hashCode() ^ 0xBABAFEEF;
        }
    }

    public static class KEqualityTuple<K, V>
    extends Tuple<K, V> {
        public KEqualityTuple(K k, V v) {
            super(k, v);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple other = (Tuple)o;
            return this.k().equals(other.k());
        }

        @Override
        public int hashCode() {
            if (this.k() == null) {
                return 0;
            }
            return this.k().hashCode() ^ 0xBABAFEEF;
        }
    }

    public static class ComparatorNotImplementedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ComparatorNotImplementedException(String msg) {
            super(msg);
        }
    }
}

