/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Function;

public class Memoizer<A, V> {
    private final ConcurrentMap<A, Future<V>> cache = new ConcurrentHashMap<A, Future<V>>();

    /*
     * Loose catch block
     */
    public V computeIfAbsent(A arg, Function<A, V> computation) throws InterruptedException {
        while (true) {
            FutureTask<Object> ft;
            FutureTask<Object> f;
            if ((f = (FutureTask<Object>)this.cache.get(arg)) == null && (f = (Future)this.cache.putIfAbsent(arg, ft = new FutureTask<Object>(() -> computation.apply(arg)))) == null) {
                f = ft;
                ft.run();
            }
            try {
                return f.get();
            }
            catch (CancellationException e) {
                this.cache.remove(arg, f);
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public void clear() {
        this.cache.clear();
    }
}

