/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.cli;

import gov.nih.ncats.common.cli.Cli;
import gov.nih.ncats.common.cli.CliOptionBuilder;
import gov.nih.ncats.common.cli.CliValidationException;
import gov.nih.ncats.common.cli.CliValidator;
import gov.nih.ncats.common.cli.InternalCliOption;
import gov.nih.ncats.common.cli.InternalCliOptionBuilder;
import gov.nih.ncats.common.cli.InternalCliSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class RadioCliOption
implements InternalCliOptionBuilder {
    private final InternalCliOptionBuilder[] choices;
    private boolean isRequired;
    private final List<CliValidator> validators = new ArrayList<CliValidator>();

    RadioCliOption(CliOptionBuilder[] choices) {
        if (choices == null || choices.length < 2) {
            throw new IllegalStateException("Radio option requires at least 2 choices");
        }
        this.choices = new InternalCliOptionBuilder[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            this.choices[i] = (InternalCliOptionBuilder)choices[i];
        }
    }

    @Override
    public InternalCliOptionBuilder addValidation(Predicate<Cli> validationRule, String errorMessage) {
        this.validators.add(new CliValidator(validationRule, errorMessage));
        return this;
    }

    @Override
    public InternalCliOptionBuilder addValidation(Predicate<Cli> validationRule, Function<Cli, String> errorMessageFunction) {
        this.validators.add(new CliValidator(validationRule, errorMessageFunction));
        return this;
    }

    @Override
    public InternalCliOptionBuilder setRequired(boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    @Override
    public InternalCliOption build() {
        return new RadioInternalCliOption(this.isRequired, (InternalCliOption[])Arrays.stream(this.choices).map(InternalCliOptionBuilder::build).toArray(InternalCliOption[]::new), this.validators);
    }

    @Override
    public InternalCliOption build(boolean isRequired) {
        return new RadioInternalCliOption(isRequired, (InternalCliOption[])Arrays.stream(this.choices).map(InternalCliOptionBuilder::build).toArray(InternalCliOption[]::new), this.validators);
    }

    private static class RadioInternalCliOption
    implements InternalCliOption {
        private final InternalCliOption[] choices;
        private final boolean isRequired;
        private final List<CliValidator> validators;

        public RadioInternalCliOption(boolean isRequired, InternalCliOption[] choices, List<CliValidator> validators) {
            this.choices = choices;
            this.isRequired = isRequired;
            this.validators = validators;
        }

        @Override
        public void addValidator(CliValidator validator) {
            this.validators.add(validator);
        }

        @Override
        public Optional<String> generateUsage(boolean force) {
            if (!force && !this.isRequired) {
                return Optional.empty();
            }
            ArrayList list = new ArrayList(this.choices.length);
            for (InternalCliOption choice : this.choices) {
                choice.generateUsage(true).ifPresent(list::add);
            }
            if (list.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(list.stream().collect(Collectors.joining(" | ", "[", "]")));
        }

        @Override
        public void addTo(InternalCliSpecification spec, Boolean forceIsRequired) {
            for (InternalCliOption choice : this.choices) {
                choice.addTo(spec, false);
            }
        }

        @Override
        public Optional<String> getMissing(Cli cli) {
            if (this.isPresent(cli)) {
                return Optional.empty();
            }
            ArrayList missing = new ArrayList();
            for (InternalCliOption choice : this.choices) {
                choice.getMissing(cli).ifPresent(missing::add);
            }
            return Optional.ofNullable(missing.stream().collect(Collectors.joining(" | ", "[ ", " ]")));
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public boolean isPresent(Cli cli) {
            for (InternalCliOption choice : this.choices) {
                if (!choice.isPresent(cli)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void validate(Cli cli) throws CliValidationException {
            List<String> seen = this.getSeenList(cli);
            if (seen.size() > 1) {
                throw new CliValidationException("Radio option must only select at most 1 choice but found " + seen);
            }
            if (this.isRequired && seen.size() == 0) {
                throw new CliValidationException("Radio option was required but did not find selected option choice");
            }
            for (InternalCliOption choice : this.choices) {
                choice.validate(cli);
            }
            for (CliValidator v : this.validators) {
                v.validate(cli);
            }
        }

        @Override
        public List<String> getSeenList(Cli cli) {
            ArrayList<String> list = new ArrayList<String>();
            for (InternalCliOption choice : this.choices) {
                List<String> seen = choice.getSeenList(cli);
                if (seen.isEmpty()) continue;
                list.add(seen.stream().collect(Collectors.joining(",", "(", ")")));
            }
            return list;
        }

        @Override
        public void fireConsumerIfNeeded(Cli cli) throws CliValidationException {
            for (InternalCliOption choice : this.choices) {
                choice.fireConsumerIfNeeded(cli);
            }
        }
    }
}

