/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.cli;

import gov.nih.ncats.common.cli.Cli;
import gov.nih.ncats.common.cli.CliOptionBuilder;
import gov.nih.ncats.common.cli.CliValidationException;
import gov.nih.ncats.common.cli.CliValidator;
import gov.nih.ncats.common.cli.InternalCliOption;
import gov.nih.ncats.common.cli.InternalCliOptionBuilder;
import gov.nih.ncats.common.cli.InternalCliSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class GroupedOption
implements InternalCliOptionBuilder {
    private final InternalCliOptionBuilder[] choices;
    private boolean isRequired;
    private final List<CliValidator> validators = new ArrayList<CliValidator>();

    public GroupedOption(CliOptionBuilder[] choices) {
        if (choices == null || choices.length < 1) {
            throw new IllegalStateException("group option requires at least 1 choices");
        }
        this.choices = new InternalCliOptionBuilder[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            this.choices[i] = (InternalCliOptionBuilder)choices[i];
        }
    }

    @Override
    public InternalCliOptionBuilder addValidation(Predicate<Cli> validationRule, String errorMessage) {
        this.validators.add(new CliValidator(validationRule, errorMessage));
        return this;
    }

    @Override
    public InternalCliOptionBuilder addValidation(Predicate<Cli> validationRule, Function<Cli, String> errorMessageFunction) {
        this.validators.add(new CliValidator(validationRule, errorMessageFunction));
        return this;
    }

    @Override
    public InternalCliOption build() {
        return new GroupedOptionCliOption(this.isRequired, (InternalCliOption[])Arrays.stream(this.choices).map(InternalCliOptionBuilder::build).toArray(InternalCliOption[]::new), this.validators);
    }

    @Override
    public InternalCliOption build(boolean isRequired) {
        return new GroupedOptionCliOption(isRequired, (InternalCliOption[])Arrays.stream(this.choices).map(InternalCliOptionBuilder::build).toArray(InternalCliOption[]::new), this.validators);
    }

    @Override
    public GroupedOption setRequired(boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    private static class GroupedOptionCliOption
    implements InternalCliOption {
        private final InternalCliOption[] choices;
        private final boolean isRequired;
        private List<InternalCliOption> requiredOptions = new ArrayList<InternalCliOption>();
        private List<InternalCliOption> optionalOptions = new ArrayList<InternalCliOption>();
        private final List<CliValidator> validators;

        public GroupedOptionCliOption(boolean isRequired, InternalCliOption[] choices, List<CliValidator> validators) {
            this.choices = choices;
            this.isRequired = isRequired;
            this.validators = validators;
            for (InternalCliOption choice : choices) {
                if (choice.isRequired()) {
                    this.requiredOptions.add(choice);
                    continue;
                }
                this.optionalOptions.add(choice);
            }
        }

        @Override
        public void addValidator(CliValidator validator) {
            this.validators.add(validator);
        }

        @Override
        public Optional<String> getMissing(Cli cli) {
            ArrayList missingOps = new ArrayList();
            for (InternalCliOption choice : this.requiredOptions) {
                choice.getMissing(cli).ifPresent(missingOps::add);
            }
            if (missingOps.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(missingOps.stream().collect(Collectors.joining(" ", "(", ")")));
        }

        @Override
        public void addTo(InternalCliSpecification spec, Boolean forceIsRequired) {
            boolean force = this.isRequired;
            if (forceIsRequired != null) {
                force = forceIsRequired;
            }
            for (InternalCliOption choice : this.choices) {
                choice.addTo(spec, choice.isRequired() && force);
            }
        }

        @Override
        public boolean isPresent(Cli cli) {
            int seen = 0;
            for (InternalCliOption choice : this.requiredOptions) {
                if (choice.isPresent(cli)) {
                    ++seen;
                    continue;
                }
                return false;
            }
            if (!this.requiredOptions.isEmpty()) {
                return seen == this.requiredOptions.size();
            }
            for (InternalCliOption choice : this.optionalOptions) {
                if (!choice.isPresent(cli)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Optional<String> generateUsage(boolean force) {
            if (!force && !this.isRequired) {
                return Optional.empty();
            }
            ArrayList list = new ArrayList(this.requiredOptions.size());
            for (InternalCliOption choice : this.requiredOptions) {
                choice.generateUsage(true).ifPresent(list::add);
            }
            String requiredGroup = list.stream().collect(Collectors.joining(","));
            ArrayList optList = new ArrayList(this.optionalOptions.size());
            for (InternalCliOption choice : this.optionalOptions) {
                choice.generateUsage(true).ifPresent(c -> optList.add("[" + c + "]"));
            }
            String optionalGroup = optList.stream().collect(Collectors.joining(","));
            if (requiredGroup.isEmpty() && optionalGroup.isEmpty()) {
                return Optional.empty();
            }
            if (requiredGroup.isEmpty()) {
                return Optional.of("(" + optionalGroup + ")");
            }
            if (optionalGroup.isEmpty()) {
                return Optional.of("(" + requiredGroup + ")");
            }
            return Optional.of("(" + requiredGroup + " " + optionalGroup + ")");
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public void validate(Cli cli) throws CliValidationException {
            ArrayList missing = new ArrayList();
            for (InternalCliOption choice : this.requiredOptions) {
                choice.getMissing(cli).ifPresent(missing::add);
            }
            if (!missing.isEmpty() && this.isRequired) {
                throw new CliValidationException("required group was not found require " + missing.stream().collect(Collectors.joining(",", "( ", " )")));
            }
            for (InternalCliOption choice : this.requiredOptions) {
                choice.validate(cli);
            }
            for (InternalCliOption choice : this.optionalOptions) {
                choice.validate(cli);
            }
            for (CliValidator v : this.validators) {
                v.validate(cli);
            }
        }

        @Override
        public List<String> getSeenList(Cli cli) {
            ArrayList<String> list = new ArrayList<String>();
            for (InternalCliOption choice : this.choices) {
                List<String> seen = choice.getSeenList(cli);
                if (seen.isEmpty()) continue;
                list.add(seen.stream().collect(Collectors.joining(",", "(", ")")));
            }
            return list;
        }

        @Override
        public void fireConsumerIfNeeded(Cli cli) throws CliValidationException {
            for (InternalCliOption choice : this.choices) {
                choice.fireConsumerIfNeeded(cli);
            }
        }
    }
}

