/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.cli;

import gov.nih.ncats.common.cli.Cli;
import gov.nih.ncats.common.cli.CliValidationException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

final class CliValidator {
    private final Predicate<Cli> validator;
    private final Function<Cli, String> errorMessage;

    public CliValidator(Predicate<Cli> validator, String errorMessage) {
        this(validator, (Cli cli) -> errorMessage);
    }

    public CliValidator(Predicate<Cli> validator, Function<Cli, String> errorMessage) {
        this.validator = Objects.requireNonNull(validator);
        this.errorMessage = Objects.requireNonNull(errorMessage);
    }

    public void validate(Cli cli) throws CliValidationException {
        if (!this.validator.test(cli)) {
            throw new CliValidationException(this.errorMessage.apply(cli));
        }
    }
}

