/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.cli;

import gov.nih.ncats.common.cli.BasicCliOption;
import gov.nih.ncats.common.cli.BasicCliOptionBuilder;
import gov.nih.ncats.common.cli.Cli;
import gov.nih.ncats.common.cli.CliOptionBuilder;
import gov.nih.ncats.common.cli.CliValidationException;
import gov.nih.ncats.common.cli.CliValidator;
import gov.nih.ncats.common.cli.GroupedOption;
import gov.nih.ncats.common.cli.InternalCliOption;
import gov.nih.ncats.common.cli.InternalCliOptionBuilder;
import gov.nih.ncats.common.cli.InternalCliSpecification;
import gov.nih.ncats.common.cli.RadioCliOption;
import gov.nih.ncats.common.cli.UsageExample;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CliSpecification {
    private static final String NEW_LINE = String.format("%n", new Object[0]);
    private static final Pattern NEXT_WHITE_SPACE_PATTERN = Pattern.compile("\\s");
    private final Options options;
    private InternalCliOption internalCliOption;
    private String programName;
    private String description;
    private String footer;
    private Set<UsageExample> examples = new LinkedHashSet<UsageExample>();

    public static CliSpecification createWithHelp(CliOptionBuilder ... options) {
        CliOptionBuilder[] helpWithOptions = new InternalCliOptionBuilder[options.length + 1];
        System.arraycopy(options, 0, helpWithOptions, 0, options.length);
        helpWithOptions[options.length] = (InternalCliOptionBuilder)((Object)CliSpecification.option("h").longName("help").description("print helptext").isFlag(true));
        return new CliSpecification(CliSpecification.group(helpWithOptions).setRequired(true));
    }

    public static CliSpecification create(CliOptionBuilder ... options) {
        return new CliSpecification(CliSpecification.group(options).setRequired(true));
    }

    public static BasicCliOptionBuilder option(String optName) {
        return new BasicCliOption(optName);
    }

    public static CliOptionBuilder radio(CliOptionBuilder ... radioOptions) {
        return new RadioCliOption(radioOptions);
    }

    public static CliOptionBuilder group(CliOptionBuilder ... options) {
        return new GroupedOption(options);
    }

    public CliSpecification addValidation(Predicate<Cli> validationRule, String errorMessage) {
        this.internalCliOption.addValidator(new CliValidator(validationRule, errorMessage));
        return this;
    }

    public CliSpecification addValidation(Predicate<Cli> validationRule, Function<Cli, String> errorMessageFunction) {
        this.internalCliOption.addValidator(new CliValidator(validationRule, errorMessageFunction));
        return this;
    }

    public CliSpecification example(String options, String explanation) {
        this.examples.add(new UsageExample(options, explanation));
        return this;
    }

    public CliSpecification footer(String footer) {
        this.footer = footer;
        return this;
    }

    public CliSpecification description(String description) {
        this.description = description;
        return this;
    }

    public CliSpecification programName(String programName) {
        this.programName = programName;
        return this;
    }

    private CliSpecification(CliOptionBuilder options) {
        InternalCliSpecification internalSpec = new InternalCliSpecification();
        this.internalCliOption = ((InternalCliOptionBuilder)options).build();
        this.internalCliOption.addTo(internalSpec, null);
        this.options = internalSpec.getInternalOptions();
    }

    public Cli parse(URL url) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        String[] split = url.getQuery().split("&");
        if (split != null) {
            for (String s : split) {
                int index = s.indexOf(61);
                if (index > 0) {
                    args.add("-" + URLDecoder.decode(s.substring(0, index), "UTF-8"));
                    args.add(URLDecoder.decode(s.substring(index + 1, s.length()), "UTF-8"));
                    continue;
                }
                args.add("-" + URLDecoder.decode(s, "UTF-8"));
            }
        }
        return this.parse(args.toArray(new String[args.size()]));
    }

    public String generateUsage() {
        StringBuilder optBuf;
        ArrayList opList;
        int width = 120;
        int leftPadding = 1;
        int descPadding = 3;
        String lpad = this.createPadding(leftPadding);
        String dpad = this.createPadding(descPadding);
        StringBuilder builder = new StringBuilder("usage: ");
        if (this.programName != null) {
            builder.append(this.programName).append(" ");
        }
        StringBuilder usagebuilder = new StringBuilder();
        this.internalCliOption.generateUsage(false).ifPresent(usagebuilder::append);
        this.renderWrappedText(builder, width, builder.length(), usagebuilder.toString());
        builder.append(NEW_LINE);
        if (this.description != null) {
            this.renderWrappedText(builder, width, 0, this.description);
            builder.append(NEW_LINE);
        }
        if (!(opList = new ArrayList(this.options.getOptions())).isEmpty()) {
            builder.append(NEW_LINE).append("options:").append(NEW_LINE);
        }
        ArrayList<StringBuilder> prefixList = new ArrayList<StringBuilder>();
        int max = 0;
        Collections.sort(opList, DEFAULT_OPTION_COMPARATOR.INSTANCE);
        for (Option option : opList) {
            optBuf = new StringBuilder();
            optBuf.append(lpad).append("    -").append(option.getOpt());
            if (option.hasLongOpt()) {
                optBuf.append(",--").append(option.getLongOpt());
            }
            if (option.hasArg()) {
                if (option.hasArgName()) {
                    optBuf.append(" <").append(option.getArgName()).append('>');
                } else {
                    optBuf.append(' ');
                }
            }
            prefixList.add(optBuf);
            max = Math.max(optBuf.length(), max);
        }
        for (int x = 0; x < opList.size(); ++x) {
            Option option;
            option = (Option)opList.get(x);
            optBuf = (StringBuilder)prefixList.get(x);
            if (optBuf.length() < max) {
                optBuf.append(this.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            int nextLineTabStop = max + descPadding;
            if (option.getDescription() != null) {
                optBuf.append(option.getDescription());
            }
            this.renderWrappedText(builder, width, nextLineTabStop, optBuf.toString());
            if (x >= opList.size() - 1) continue;
            builder.append(NEW_LINE).append(NEW_LINE);
        }
        if (!this.examples.isEmpty()) {
            builder.append(NEW_LINE).append(NEW_LINE).append("Examples:").append(NEW_LINE);
            for (UsageExample example : this.examples) {
                builder.append(NEW_LINE).append(lpad).append("     $");
                if (this.programName != null) {
                    builder.append(this.programName).append(' ');
                }
                this.renderWrappedText(builder, width, descPadding, example.getUsage());
                builder.append(NEW_LINE).append(NEW_LINE).append(dpad);
                this.renderWrappedText(builder, width, descPadding, example.getDescription());
                builder.append(NEW_LINE);
            }
        }
        if (this.footer != null) {
            builder.append(NEW_LINE);
            this.renderWrappedText(builder, width, 0, this.footer);
        }
        builder.append(NEW_LINE);
        return builder.toString();
    }

    private void renderWrappedText(StringBuilder builder, int width, int nextLineTabStop, String optionString) {
        String text = optionString;
        int pos = this.findWrapPos(text, width, 0);
        if (pos == -1) {
            builder.append(this.rTrim(text));
            return;
        }
        builder.append(this.rTrim(text.substring(0, pos))).append(NEW_LINE);
        String padding = this.createPadding(nextLineTabStop);
        while (true) {
            if ((pos = this.findWrapPos(text = padding + text.substring(pos).trim(), width, nextLineTabStop)) == -1) {
                builder.append(text);
                return;
            }
            builder.append(this.rTrim(text.substring(0, pos))).append(NEW_LINE);
        }
    }

    private String rTrim(String buf) {
        int pos;
        for (pos = buf.length(); pos > 0 && Character.isWhitespace(buf.charAt(pos - 1)); --pos) {
        }
        return buf.substring(0, pos);
    }

    private int findWrapPos(String text, int width, int startPos) {
        if (text.length() < width) {
            return -1;
        }
        String subString = new StringBuilder(text.substring(0, width)).reverse().toString();
        Matcher matcher = NEXT_WHITE_SPACE_PATTERN.matcher(subString);
        if (matcher.find()) {
            int foundPosition = matcher.start();
            return subString.length() - foundPosition;
        }
        return -1;
    }

    private String createPadding(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    public boolean helpRequested(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String v = args[i];
            if (!"-h".equals(v) && !"--help".equals(v) && !"--h".equals(v) && !"-help".equals(v)) continue;
            return true;
        }
        return false;
    }

    public Cli parse(String[] args) throws CliValidationException {
        Cli cli;
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmdline = parser.parse(this.options, args);
            cli = new Cli(cmdline);
        }
        catch (ParseException e) {
            throw new CliValidationException(e);
        }
        this.internalCliOption.validate(cli);
        this.internalCliOption.fireConsumerIfNeeded(cli);
        return cli;
    }

    private static enum DEFAULT_OPTION_COMPARATOR implements Comparator<Option>
    {
        INSTANCE;


        @Override
        public int compare(Option o1, Option o2) {
            return o1.getOpt().compareTo(o2.getOpt());
        }
    }
}

