/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.cli;

import gov.nih.ncats.common.cli.BasicCliOptionBuilder;
import gov.nih.ncats.common.cli.Cli;
import gov.nih.ncats.common.cli.CliValidationException;
import gov.nih.ncats.common.cli.CliValidator;
import gov.nih.ncats.common.cli.InternalCliOption;
import gov.nih.ncats.common.cli.InternalCliOptionBuilder;
import gov.nih.ncats.common.cli.InternalCliSpecification;
import gov.nih.ncats.common.functions.ThrowableConsumer;
import gov.nih.ncats.common.functions.ThrowableFunction;
import gov.nih.ncats.common.functions.ThrowableIntConsumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.apache.commons.cli.Option;

class BasicCliOption
implements InternalCliOptionBuilder,
BasicCliOptionBuilder {
    private String name;
    private String description;
    private String longName;
    private boolean isRequired;
    private String argName;
    private ThrowableConsumer<String, CliValidationException> consumer = s -> {};
    private List<CliValidator> validators = new ArrayList<CliValidator>();
    private boolean isFlag;

    BasicCliOption(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public BasicCliOptionBuilder addValidation(Predicate<Cli> validationRule, String errorMessage) {
        this.validators.add(new CliValidator(validationRule, errorMessage));
        return this;
    }

    @Override
    public BasicCliOptionBuilder addValidation(Predicate<Cli> validationRule, Function<Cli, String> errorMessageFunction) {
        this.validators.add(new CliValidator(validationRule, errorMessageFunction));
        return this;
    }

    @Override
    public BasicCliOptionBuilder argName(String argName) {
        this.argName = argName;
        return this;
    }

    @Override
    public BasicCliOptionBuilder longName(String longName) {
        this.longName = longName;
        return this;
    }

    @Override
    public BasicCliOptionBuilder description(String description) {
        this.description = Objects.requireNonNull(description);
        return this;
    }

    @Override
    public BasicCliOption isFlag(boolean isFlag) {
        this.isFlag = isFlag;
        return this;
    }

    public BasicCliOptionBuilder required(boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    @Override
    public BasicCliOption setRequired(boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    @Override
    public <T extends Throwable> BasicCliOption setter(ThrowableConsumer<String, T> consumer) {
        return this.setter(ThrowableFunction.identity(), (ThrowableConsumer)consumer, (Predicate)null);
    }

    @Override
    public <T extends Throwable> BasicCliOptionBuilder setToFile(ThrowableConsumer<File, T> consumer) {
        Objects.requireNonNull(consumer);
        this.consumer = s -> {
            try {
                consumer.accept((Object)new File((String)s));
            }
            catch (Throwable t) {
                if (t instanceof CliValidationException) {
                    throw (CliValidationException)t;
                }
                throw new CliValidationException(t.getMessage(), t);
            }
        };
        return this;
    }

    @Override
    public <T extends Throwable> BasicCliOptionBuilder setToInt(ThrowableIntConsumer<T> consumer, IntPredicate validator) {
        if (validator == null) {
            return this.setToInt((ThrowableIntConsumer)consumer);
        }
        this.consumer = s -> {
            int value;
            try {
                value = Integer.parseInt(s);
            }
            catch (Throwable t) {
                throw new CliValidationException("error parsing int value", t);
            }
            if (validator.test(value)) {
                try {
                    consumer.accept(value);
                }
                catch (Throwable t) {
                    if (t instanceof CliValidationException) {
                        throw (CliValidationException)t;
                    }
                    throw new CliValidationException(t.getMessage(), t);
                }
            } else {
                throw new CliValidationException("setter did not pass validation test");
            }
        };
        return this;
    }

    @Override
    public <T extends Throwable, R> BasicCliOption setter(ThrowableFunction<String, R, T> typeConverter, ThrowableConsumer<R, T> consumer, Predicate<R> validator) {
        this.consumer = validator == null ? s -> {
            try {
                consumer.accept(typeConverter.apply(s));
            }
            catch (Throwable t) {
                if (t instanceof CliValidationException) {
                    throw (CliValidationException)t;
                }
                throw new CliValidationException(t.getMessage(), t);
            }
        } : s -> {
            Object value;
            try {
                value = typeConverter.apply(s);
            }
            catch (Throwable t) {
                if (t instanceof CliValidationException) {
                    throw (CliValidationException)t;
                }
                throw new CliValidationException(t);
            }
            if (validator.test(value)) {
                try {
                    consumer.accept(value);
                }
                catch (Throwable t) {
                    if (t instanceof CliValidationException) {
                        throw (CliValidationException)t;
                    }
                    throw new CliValidationException(t.getMessage(), t);
                }
            } else {
                throw new CliValidationException("setter did not pass validation test");
            }
        };
        return this;
    }

    @Override
    public <T extends Throwable> BasicCliOptionBuilder setter(ThrowableConsumer<String, T> consumer, Predicate<String> validator) {
        return this.setter(ThrowableFunction.identity(), (ThrowableConsumer)consumer, validator);
    }

    @Override
    public <T extends Throwable> BasicCliOption setToInt(ThrowableIntConsumer<T> consumer) {
        Objects.requireNonNull(consumer);
        this.consumer = s -> {
            try {
                consumer.accept(Integer.parseInt(s));
            }
            catch (Throwable t) {
                throw new CliValidationException(t);
            }
        };
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ThrowableConsumer<String, CliValidationException> getConsumer() {
        return this.consumer;
    }

    Option asApacheOption() {
        return Option.builder((String)this.name).required(this.isRequired).longOpt(this.longName).desc(this.description).hasArg(!this.isFlag).argName(this.argName).build();
    }

    @Override
    public InternalCliOption build() {
        return new InternalBasicCliOption(this.asApacheOption(), this.consumer, this.isRequired, this.validators);
    }

    @Override
    public InternalCliOption build(boolean isRequired) {
        Option option = this.asApacheOption();
        option.setRequired(isRequired);
        return new InternalBasicCliOption(option, this.consumer, this.isRequired, this.validators);
    }

    private static final class InternalBasicCliOption
    implements InternalCliOption {
        private final Option option;
        private final ThrowableConsumer<String, CliValidationException> consumer;
        private final boolean isRequired;
        private final List<CliValidator> validators;

        private InternalBasicCliOption(Option option, ThrowableConsumer<String, CliValidationException> consumer, boolean isRequired, List<CliValidator> validators) {
            this.option = option;
            this.consumer = consumer;
            this.isRequired = isRequired;
            this.validators = validators;
        }

        @Override
        public void addValidator(CliValidator validator) {
            this.validators.add(validator);
        }

        @Override
        public Optional<String> generateUsage(boolean force) {
            if (!force && !this.isRequired()) {
                return Optional.empty();
            }
            return Optional.of("-" + this.option.getOpt() + (this.option.getArgName() == null ? "" : " <" + this.option.getArgName() + ">"));
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public void addTo(InternalCliSpecification spec, Boolean forceIsRequired) {
            if (forceIsRequired != null) {
                this.option.setRequired(forceIsRequired.booleanValue());
            }
            spec.getInternalOptions().addOption(this.option);
        }

        @Override
        public Optional<String> getMissing(Cli cli) {
            if (this.isPresent(cli)) {
                return Optional.empty();
            }
            return Optional.ofNullable("-" + this.option.getOpt());
        }

        @Override
        public boolean isPresent(Cli cli) {
            return cli.hasOption(this.option.getOpt());
        }

        @Override
        public void validate(Cli cli) throws CliValidationException {
            boolean isPresent = this.isPresent(cli);
            if (this.option.isRequired() && !isPresent) {
                throw new CliValidationException(this.option.getOpt() + " is required");
            }
            if (isPresent) {
                for (CliValidator v : this.validators) {
                    v.validate(cli);
                }
            }
        }

        @Override
        public void fireConsumerIfNeeded(Cli cli) throws CliValidationException {
            if (this.isPresent(cli)) {
                this.consumer.accept((Object)cli.getOptionValue(this.option.getOpt()));
            }
        }

        @Override
        public List<String> getSeenList(Cli cli) {
            if (this.isPresent(cli)) {
                return Collections.singletonList(this.option.getOpt());
            }
            return Collections.emptyList();
        }
    }
}

