/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.writer;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.function.Function;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.IChemObjectWriter;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.setting.IOSetting;

public class ChemObjectWriterAdapter<T extends IChemObject>
implements IChemObjectWriter,
Closeable {
    private final IChemObjectWriter delegate;
    private final Function<T, T> adapter;

    public static <T extends IChemObject> ChemObjectWriterAdapter<T> create(IChemObjectWriter delegate, Function<T, T> adapter) {
        return new ChemObjectWriterAdapter<T>(delegate, adapter);
    }

    private ChemObjectWriterAdapter(IChemObjectWriter delegate, Function<T, T> adapter) {
        this.delegate = delegate;
        this.adapter = adapter;
    }

    public IResourceFormat getFormat() {
        return this.delegate.getFormat();
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        return this.delegate.accepts(classObject);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public IOSetting[] getIOSettings() {
        return this.delegate.getIOSettings();
    }

    public void addChemObjectIOListener(IChemObjectIOListener listener) {
        this.delegate.addChemObjectIOListener(listener);
    }

    public void removeChemObjectIOListener(IChemObjectIOListener listener) {
        this.delegate.removeChemObjectIOListener(listener);
    }

    public Collection<IChemObjectIOListener> getListeners() {
        return this.delegate.getListeners();
    }

    public <S extends IOSetting> S addSetting(IOSetting setting) {
        return (S)this.delegate.addSetting(setting);
    }

    public void addSettings(Collection<IOSetting> settings) {
        this.delegate.addSettings(settings);
    }

    public boolean hasSetting(String name) {
        return this.delegate.hasSetting(name);
    }

    public <S extends IOSetting> S getSetting(String name) {
        return (S)this.delegate.getSetting(name);
    }

    public <S extends IOSetting> S getSetting(String name, Class<S> c) {
        return (S)this.delegate.getSetting(name, c);
    }

    public Collection<IOSetting> getSettings() {
        return this.delegate.getSettings();
    }

    public void write(IChemObject object) throws CDKException {
        this.delegate.write((IChemObject)this.adapter.apply(object));
    }

    public void setWriter(Writer writer) throws CDKException {
        this.delegate.setWriter(writer);
    }

    public void setWriter(OutputStream writer) throws CDKException {
        this.delegate.setWriter(writer);
    }
}

