/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.writer;

import gov.nih.ncats.molwitch.cdk.CdkChemicalImpl;
import gov.nih.ncats.molwitch.spi.ChemicalImpl;
import gov.nih.ncats.molwitch.spi.ChemicalWriterImpl;
import java.io.IOException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.IChemObjectWriter;

public class CdkChemicalWriter
implements ChemicalWriterImpl {
    private final IChemObjectWriter writer;

    public CdkChemicalWriter(IChemObjectWriter writer) {
        this.writer = writer;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(ChemicalImpl impl) throws IOException {
        CdkChemicalImpl chem = (CdkChemicalImpl)impl;
        IAtomContainer mol = chem.getContainer();
        try {
            this.writer.write((IChemObject)mol);
        }
        catch (Throwable e) {
            throw new IOException("error writing container " + mol.getID(), e);
        }
    }
}

