/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.writer;

import gov.nih.ncats.molwitch.cdk.writer.ChemObjectWriterAdapter;
import gov.nih.ncats.molwitch.cdk.writer.SingleCdkChemicalWriter;
import gov.nih.ncats.molwitch.io.ChemFormat;
import gov.nih.ncats.molwitch.spi.ChemicalWriterImpl;
import gov.nih.ncats.molwitch.spi.ChemicalWriterImplFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.function.Function;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.io.IChemObjectWriter;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.listener.PropertiesListener;

public abstract class AbstractMdlWriterFactory
implements ChemicalWriterImplFactory {
    protected abstract boolean supportsVersion(ChemFormat.MolFormatSpecification.Version var1);

    public ChemicalWriterImpl newInstance(OutputStream out, ChemFormat.ChemFormatWriterSpecification spec) throws IOException {
        IChemObjectWriter writer = this.create(out);
        Function<Object, Object> adapter = Function.identity();
        if (spec instanceof ChemFormat.AromaticAwareChemFormatWriterSpecification) {
            Properties customSettings = new Properties();
            customSettings.setProperty("WriteAromaticBondTypes", Boolean.toString(((ChemFormat.AromaticAwareChemFormatWriterSpecification)spec).getKekulization() == ChemFormat.KekulizationEncoding.FORCE_AROMATIC));
            PropertiesListener listener = new PropertiesListener(customSettings);
            if (spec instanceof ChemFormat.MolFormatSpecification) {
                ChemFormat.MolFormatSpecification molSpec = (ChemFormat.MolFormatSpecification)spec;
                switch (molSpec.getCoordinateOptions()) {
                    case FORCE_2D: {
                        customSettings.setProperty("OptForceWriteAs2DCoordinates", Boolean.toString(true));
                        adapter = c -> {
                            boolean mustChange = false;
                            for (IAtom a : c.atoms()) {
                                if (a.getPoint2d() != null || a.getPoint3d() == null) continue;
                                mustChange = true;
                            }
                            if (mustChange) {
                                IAtomContainer clone;
                                try {
                                    clone = c.clone();
                                }
                                catch (CloneNotSupportedException e) {
                                    return c;
                                }
                                for (IAtom a : clone.atoms()) {
                                    Point3d points = a.getPoint3d();
                                    if (points == null) continue;
                                    a.setPoint2d(new Point2d(points.x, points.y));
                                }
                                return clone;
                            }
                            return c;
                        };
                        break;
                    }
                    default: {
                        customSettings.setProperty("OptForceWriteAs2DCoordinates", Boolean.toString(false));
                        adapter = c -> {
                            boolean mustChange = false;
                            for (IAtom a : c.atoms()) {
                                if (a.getPoint3d() != null || a.getPoint2d() == null) continue;
                                mustChange = true;
                            }
                            if (mustChange) {
                                IAtomContainer clone;
                                try {
                                    clone = c.clone();
                                }
                                catch (CloneNotSupportedException e) {
                                    return c;
                                }
                                for (IAtom a : clone.atoms()) {
                                    Point2d points = a.getPoint2d();
                                    if (points == null) continue;
                                    a.setPoint3d(new Point3d(points.x, points.y, 0.0));
                                }
                                return clone;
                            }
                            return c;
                        };
                    }
                }
            }
            writer.addChemObjectIOListener((IChemObjectIOListener)listener);
        }
        return new SingleCdkChemicalWriter(ChemObjectWriterAdapter.create(writer, adapter));
    }

    public boolean supports(ChemFormat.ChemFormatWriterSpecification spec) {
        if (!"mol".equalsIgnoreCase(spec.getFormatName())) {
            return false;
        }
        if (spec instanceof ChemFormat.MolFormatSpecification) {
            return this.supportsVersion(((ChemFormat.MolFormatSpecification)spec).getVersion());
        }
        return false;
    }

    protected abstract IChemObjectWriter create(OutputStream var1) throws IOException;
}

