/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk;

import gov.nih.ncats.molwitch.cdk.CdkChemical2FactoryImpl;
import gov.nih.ncats.molwitch.cdk.IdAwareSdfReader;
import gov.nih.ncats.molwitch.cdk.ProgramClearingMol2000Wrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.io.iterator.IIteratingChemObjectReader;
import org.openscience.cdk.io.iterator.IteratingSMILESReader;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class ReaderFactory {
    GuessResult guessReaderFor(BufferedReader reader) throws IOException {
        reader.mark(Short.MAX_VALUE);
        reader.readLine();
        reader.readLine();
        reader.readLine();
        String header = reader.readLine();
        reader.reset();
        if (header != null && (header.indexOf("V2000") >= 0 || header.indexOf("V3000") >= 0)) {
            CdkChemical2FactoryImpl.SavedBufferedReader savedReader = new CdkChemical2FactoryImpl.SavedBufferedReader(new ProgramClearingMol2000Wrapper(reader));
            return new GuessResult((IIteratingChemObjectReader<IAtomContainer>)new IdAwareSdfReader(savedReader, SilentChemObjectBuilder.getInstance()), savedReader);
        }
        CdkChemical2FactoryImpl.SavedBufferedReader savedReader = new CdkChemical2FactoryImpl.SavedBufferedReader(reader);
        return new GuessResult((IIteratingChemObjectReader<IAtomContainer>)new IteratingSMILESReader((Reader)savedReader, SilentChemObjectBuilder.getInstance()), savedReader);
    }

    static class GuessResult {
        public final IIteratingChemObjectReader<IAtomContainer> cdkReader;
        public final CdkChemical2FactoryImpl.SavedBufferedReader savedBufferedReader;

        public GuessResult(IIteratingChemObjectReader<IAtomContainer> cdkReader, CdkChemical2FactoryImpl.SavedBufferedReader savedBufferedReader) {
            this.cdkReader = cdkReader;
            this.savedBufferedReader = savedBufferedReader;
        }
    }
}

