/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk;

import java.io.IOException;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.BondRef;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryBond;

public class QueryAtomPerceptor {
    public static void percieve(IAtomContainer container) throws IOException {
        Expr expr;
        IAtom deref;
        for (IAtom atom : container.atoms()) {
            deref = AtomRef.deref((IAtom)atom);
            if (!(deref instanceof QueryAtom)) continue;
            expr = ((QueryAtom)deref).getExpression();
            System.out.println(expr.type());
            if (expr.type() != Expr.Type.ELEMENT && expr.type() != Expr.Type.ALIPHATIC_ELEMENT && expr.type() != Expr.Type.AROMATIC_ELEMENT) continue;
            int atomicNumber = expr.value();
            IElement element = Isotopes.getInstance().getElement(atomicNumber);
            atom.setAtomicNumber(Integer.valueOf(atomicNumber));
            atom.setSymbol(element.getSymbol());
            if (expr.type() != Expr.Type.AROMATIC_ELEMENT) continue;
            atom.setIsAromatic(true);
        }
        for (IBond bond : container.bonds()) {
            deref = BondRef.deref((IBond)bond);
            System.out.println(deref);
            if (!(deref instanceof QueryBond)) continue;
            expr = ((QueryBond)deref).getExpression();
            System.out.println("\t" + expr);
            if (expr.type() == Expr.Type.ALIPHATIC_ORDER || expr.type() == Expr.Type.ORDER) {
                switch (expr.value()) {
                    case 1: {
                        bond.setOrder(IBond.Order.SINGLE);
                        break;
                    }
                    case 2: {
                        bond.setOrder(IBond.Order.DOUBLE);
                        break;
                    }
                    case 3: {
                        bond.setOrder(IBond.Order.TRIPLE);
                        break;
                    }
                    case 4: {
                        bond.setOrder(IBond.Order.QUADRUPLE);
                    }
                }
            }
            if (expr.type() != Expr.Type.SINGLE_OR_AROMATIC) continue;
            bond.setOrder(IBond.Order.SINGLE);
            bond.setIsAromatic(true);
            bond.setIsInRing(true);
        }
    }
}

