/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.iterator.IteratingSDFReader;

public class IdAwareSdfReader
extends IteratingSDFReader {
    private boolean alreadyCalledHasNext;
    private BufferedReader in;
    private String nextId;

    public IdAwareSdfReader(BufferedReader in, IChemObjectBuilder builder) {
        super((Reader)in, builder);
        this.in = in;
    }

    public boolean hasNext() {
        if (!this.alreadyCalledHasNext) {
            try {
                this.in.mark(2048);
                this.nextId = this.in.readLine();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.in.reset();
                }
                catch (IOException iOException) {}
            }
        }
        boolean next = super.hasNext();
        this.alreadyCalledHasNext = true;
        return next;
    }

    public IAtomContainer next() {
        IAtomContainer ret = super.next();
        ret.setID(this.nextId);
        ret.setProperty((Object)"cdk:Title", (Object)this.nextId);
        this.alreadyCalledHasNext = false;
        return ret;
    }
}

