/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk;

import gov.nih.ncats.molwitch.Chemical;
import gov.nih.ncats.molwitch.ChemicalBuilder;
import gov.nih.ncats.molwitch.ChemicalSource;
import gov.nih.ncats.molwitch.cdk.CdkChemicalImpl;
import gov.nih.ncats.molwitch.inchi.InChiResult;
import gov.nih.ncats.molwitch.internal.source.StringSource;
import gov.nih.ncats.molwitch.spi.ChemicalImpl;
import gov.nih.ncats.molwitch.spi.InchiImplFactory;
import java.io.IOException;
import java.util.Collections;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.inchi.InChIToStructure;
import org.openscience.cdk.interfaces.IAtomContainer;

public class CdkChemicalInchiImplFactory
implements InchiImplFactory {
    private final InChIGeneratorFactory factory;

    public CdkChemicalInchiImplFactory() {
        try {
            this.factory = InChIGeneratorFactory.getInstance();
        }
        catch (CDKException e) {
            throw new IllegalStateException("could not initialize Inchi generator", e);
        }
    }

    public InChiResult asStdInchi(Chemical chemical, boolean trustCoordinates) throws IOException {
        try {
            InChIGenerator gen = this.factory.getInChIGenerator((IAtomContainer)chemical.getImpl().getWrappedObject(), Collections.emptyList());
            InChiResult.Status status = this.toChemkitStatus(gen.getReturnStatus());
            return new InChiResult.Builder(status).setAuxInfo(gen.getAuxInfo()).setInchi(gen.getInchi()).setKey(gen.getInchiKey()).setMessage(gen.getLog()).build();
        }
        catch (CDKException e) {
            throw new IOException("error computing Inchi", e);
        }
    }

    private InChiResult.Status toChemkitStatus(INCHI_RET returnStatus) {
        if (returnStatus == INCHI_RET.OKAY) {
            return InChiResult.Status.VALID;
        }
        if (returnStatus == INCHI_RET.WARNING) {
            return InChiResult.Status.WARNING;
        }
        return InChiResult.Status.ERROR;
    }

    public Chemical parseInchi(String inchi) throws IOException {
        try {
            InChIToStructure toStruc = this.factory.getInChIToStructure(inchi, DefaultChemObjectBuilder.getInstance());
            System.out.println(toStruc.getReturnStatus() + "  " + toStruc.getMessage());
            if (toStruc.getReturnStatus() == INCHI_RET.OKAY || toStruc.getReturnStatus() == INCHI_RET.WARNING) {
                return ChemicalBuilder._fromImpl((ChemicalImpl)new CdkChemicalImpl(toStruc.getAtomContainer(), (ChemicalSource)new StringSource(inchi, ChemicalSource.Type.INCHI))).build();
            }
            throw new IOException("error trying to parse inchi '" + inchi + "' : " + toStruc.getMessage());
        }
        catch (CDKException e) {
            throw new IOException("error trying to parse inchi '" + inchi + "'", e);
        }
    }
}

