/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk;

import gov.nih.ncats.common.util.CachedSupplier;
import gov.nih.ncats.molwitch.Atom;
import gov.nih.ncats.molwitch.AtomCoordinates;
import gov.nih.ncats.molwitch.Bond;
import gov.nih.ncats.molwitch.BondTable;
import gov.nih.ncats.molwitch.ChemicalSource;
import gov.nih.ncats.molwitch.ChemkitException;
import gov.nih.ncats.molwitch.Chirality;
import gov.nih.ncats.molwitch.DoubleBondStereochemistry;
import gov.nih.ncats.molwitch.ExtendedTetrahedralChirality;
import gov.nih.ncats.molwitch.GraphInvariant;
import gov.nih.ncats.molwitch.SGroup;
import gov.nih.ncats.molwitch.Stereocenter;
import gov.nih.ncats.molwitch.TetrahedralChirality;
import gov.nih.ncats.molwitch.cdk.CdkAtom;
import gov.nih.ncats.molwitch.cdk.CdkBond;
import gov.nih.ncats.molwitch.cdk.CdkGraphInvariant;
import gov.nih.ncats.molwitch.cdk.CdkUtil;
import gov.nih.ncats.molwitch.isotopes.Isotope;
import gov.nih.ncats.molwitch.spi.ChemicalImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Tuple2d;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.aromaticity.Kekulization;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.cip.CIPTool;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.invariant.Canon;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupBracket;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.stereo.StereoElementFactory;
import org.openscience.cdk.stereo.Stereocenters;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class CdkChemicalImpl
implements ChemicalImpl<CdkChemicalImpl> {
    private final ConcurrentHashMap<IAtom, CdkAtom> atoms = new ConcurrentHashMap();
    private final ConcurrentHashMap<IBond, CdkBond> bonds = new ConcurrentHashMap();
    private IAtomContainer container;
    private boolean isAromatic;
    CDKHydrogenAdder hydrogenAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)SilentChemObjectBuilder.getInstance());
    CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)SilentChemObjectBuilder.getInstance());
    Map<Integer, Map<Integer, CdkBond>> bondMap = new HashMap<Integer, Map<Integer, CdkBond>>();
    CachedSupplier<Void> perceiveAtomTypesOfNonQueryAtoms = CachedSupplier.of(() -> {
        try {
            this.percieveAtomTypeAndConfigureNonQueryAtoms();
        }
        catch (CDKException cDKException) {
            // empty catch block
        }
        return null;
    });
    CachedSupplier<Void> cahnIngoldPrelogSupplier = CachedSupplier.of(() -> {
        CIPTool.label((IAtomContainer)this.container);
        return null;
    });
    CachedSupplier<Void> ringsSearcherSupplier = CachedSupplier.of(() -> {
        AllRingsFinder arf = new AllRingsFinder();
        try {
            IRingSet ringSet = arf.findAllRings(this.container);
            for (int ir = 0; ir < ringSet.getAtomContainerCount(); ++ir) {
                IAtom aring;
                int jr;
                IRing ring = (IRing)ringSet.getAtomContainer(ir);
                for (jr = 0; jr < ring.getAtomCount(); ++jr) {
                    aring = ring.getAtom(jr);
                    aring.setFlag(2, true);
                }
                for (jr = 0; jr < ring.getBondCount(); ++jr) {
                    aring = ring.getBond(jr);
                    aring.setFlag(2, true);
                }
            }
            return null;
        }
        catch (CDKException e) {
            throw new RuntimeException(e);
        }
    });
    private final ChemicalSource source;

    public CdkChemicalImpl(IAtomContainer container, Supplier<? extends ChemicalSource> source) {
        this(container, source.get());
    }

    public CdkChemicalImpl(IAtomContainer container, ChemicalSource source) {
        this.container = container;
        this.source = source;
        for (IAtom atom : container.atoms()) {
            IAtomType type;
            if (atom instanceof IQueryAtom) continue;
            try {
                type = this.matcher.findMatchingAtomType(container, atom);
            }
            catch (CDKException e) {
                throw new IllegalStateException("error matching type", e);
            }
            AtomTypeManipulator.configure((IAtom)atom, (IAtomType)type);
        }
    }

    public void flipChirality(Stereocenter s) {
        for (Atom a : s.getPeripheralAtoms()) {
            for (Bond b : a.getBonds()) {
                Bond.Stereo newStereo;
                Bond.Stereo oldStereo = b.getStereo();
                if (oldStereo == (newStereo = oldStereo.flip())) continue;
                IAtom iAtom = CdkAtom.getIAtomFor(s.getCenterAtom());
            }
        }
    }

    public ChemicalSource getSource() {
        return this.source;
    }

    public int getSmallestRingSize() {
        IRingSet ringSet = Cycles.sssr((IAtomContainer)this.container).toRingSet();
        int numRings = ringSet.getAtomContainerCount();
        if (numRings == 0) {
            return 0;
        }
        int minSize = Integer.MAX_VALUE;
        for (int i = 0; i < numRings; ++i) {
            int s = ringSet.getAtomContainer(i).getAtomCount();
            if (s >= minSize) continue;
            minSize = s;
        }
        return minSize;
    }

    public Object getWrappedObject() {
        return this.container;
    }

    public CdkChemicalImpl shallowCopy() {
        return new CdkChemicalImpl((IAtomContainer)CdkUtil.getChemObjectBuilder().newInstance(IAtomContainer.class, new Object[]{this.container}), this.source);
    }

    public CdkChemicalImpl deepCopy() {
        try {
            return new CdkChemicalImpl(this.container.clone(), this.source);
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public Atom addAtom(String symbol) {
        org.openscience.cdk.Atom atom = new org.openscience.cdk.Atom(symbol);
        return this.addAtom((IAtom)atom);
    }

    public void addChemical(ChemicalImpl<CdkChemicalImpl> other) {
        this.container.add((IAtomContainer)other.getWrappedObject());
        this.setDirty();
    }

    public Atom addAtom(Atom a) {
        IAtom iatom = CdkAtom.getIAtomFor(a);
        return this.addAtom(iatom);
    }

    private Atom addAtom(IAtom iatom) {
        this.container.addAtom(iatom);
        this.setDirty();
        return this.getCdkAtomFor(iatom);
    }

    public Atom addAtom(Isotope isotope) {
        IAtom a = CdkUtil.getChemObjectBuilder().newAtom();
        a.setSymbol(isotope.getSymbol());
        a.setAtomicNumber(Integer.valueOf(isotope.getAtomicNumber()));
        a.setExactMass(Double.valueOf(isotope.getMassNumber()));
        a.setNaturalAbundance(Double.valueOf(isotope.getRelativeAtomicMass().getValue().doubleValue()));
        return this.addAtom(a);
    }

    public Atom addAtomByAtomicNum(int atomicNumber) {
        return this.addAtom(PeriodicTable.getSymbol((int)atomicNumber));
    }

    private void setDirty() {
        this.ringsSearcherSupplier.resetCache();
        this.cahnIngoldPrelogSupplier.resetCache();
        this.perceiveAtomTypesOfNonQueryAtoms.resetCache();
    }

    public void makeHydrogensExplicit() {
        AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)this.container);
        this.setDirty();
    }

    public boolean hasImplicitHydrogens() {
        int atomCount = this.container.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            Atom atom = this.getAtom(i);
            Integer implicitNum = atom.getImplicitHCount();
            if (implicitNum == null || implicitNum <= 0) continue;
            return true;
        }
        return false;
    }

    public void makeHydrogensImplicit() {
        AtomContainerManipulator.suppressHydrogens((IAtomContainer)this.container);
        this.setDirty();
    }

    public boolean isAromatic() {
        return this.isAromatic;
    }

    public boolean hasCoordinates() {
        return this.getDim() > 0;
    }

    public boolean has2DCoordinates() {
        return this.getDim() == 2;
    }

    public boolean has3DCoordinates() {
        return this.getDim() == 3;
    }

    private int getDim() {
        boolean has2dCoords = true;
        boolean has3dCoords = true;
        for (IAtom atom : this.container.atoms()) {
            if (atom.getPoint3d() == null) {
                has3dCoords = false;
            }
            if (atom.getPoint2d() == null) {
                has2dCoords = false;
            }
            if (has2dCoords || has3dCoords) continue;
            return 0;
        }
        if (has3dCoords) {
            return 3;
        }
        if (has2dCoords) {
            return 2;
        }
        return 0;
    }

    public String getName() {
        return this.container.getID();
    }

    public void setName(String name) {
        this.container.setID(name);
        this.container.setProperty((Object)"cdk:Title", (Object)name);
    }

    CdkAtom getCdkAtomFor(IAtom atom) {
        return this.atoms.computeIfAbsent(atom, a -> new CdkAtom((IAtom)a, this));
    }

    CdkBond getCdkBondFor(IBond bond) {
        for (Map.Entry<IBond, CdkBond> entry : this.bonds.entrySet()) {
            IBond key = entry.getKey();
            if ((!bond.getAtom(0).equals(key.getAtom(0)) || !bond.getAtom(1).equals(key.getAtom(1))) && (!bond.getAtom(1).equals(key.getAtom(0)) || !bond.getAtom(0).equals(key.getAtom(1)))) continue;
            return entry.getValue();
        }
        return this.bonds.computeIfAbsent(bond, b -> new CdkBond((IBond)b, this));
    }

    List<CdkBond> getBondsFor(IAtom atom) {
        ArrayList<CdkBond> bonds = new ArrayList<CdkBond>();
        for (IBond bond : this.container.bonds()) {
            if (!bond.contains(atom)) continue;
            bonds.add(this.getCdkBondFor(bond));
        }
        return bonds;
    }

    public double getMass() {
        return AtomContainerManipulator.getNaturalExactMass((IAtomContainer)this.container);
    }

    public int getAtomCount() {
        return this.container.getAtomCount();
    }

    public int getBondCount() {
        return this.container.getBondCount();
    }

    public Atom getAtom(int i) {
        return this.getCdkAtomFor(this.container.getAtom(i));
    }

    public Atom removeAtom(int i) {
        IAtom atom = this.container.getAtom(i);
        this.container.removeAtom(atom);
        CdkAtom retAtom = this.getCdkAtomFor(atom);
        this.setDirty();
        return retAtom;
    }

    public Atom removeAtom(Atom a) {
        if (!(a instanceof CdkAtom)) {
            throw new IllegalArgumentException("wrong type");
        }
        IAtom iatom = ((CdkAtom)a).getAtom();
        this.container.removeAtom(iatom);
        this.setDirty();
        return a;
    }

    public Bond removeBond(int i) {
        IBond ibond = this.container.removeBond(i);
        CdkBond b = this.getCdkBondFor(ibond);
        this.setDirty();
        return b;
    }

    public Bond removeBond(Bond b) {
        IBond iBond = ((CdkBond)b).getBond();
        this.container.removeBond(iBond);
        this.setDirty();
        return b;
    }

    public Bond removeBond(Atom a, Atom b) {
        IBond iBond = this.container.removeBond(CdkAtom.getIAtomFor(a), CdkAtom.getIAtomFor(b));
        this.setDirty();
        return this.getCdkBondFor(iBond);
    }

    public IAtomContainer getContainer() {
        return this.container;
    }

    public void aromatize() {
        try {
            new Aromaticity(ElectronDonation.daylight(), Cycles.all()).apply(this.container);
            this.isAromatic = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void percieveAtomTypeAndConfigureNonQueryAtoms() throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)this.container.getBuilder());
        for (IAtom atom : this.container.atoms()) {
            IAtomType matched = matcher.findMatchingAtomType(this.container, atom);
            if (matched == null) continue;
            try {
                AtomTypeManipulator.configure((IAtom)atom, (IAtomType)matched);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public void expandSGroups() {
    }

    public void generateCoordinates() throws ChemkitException {
        try {
            StructureDiagramGenerator coordinateGenerator = new StructureDiagramGenerator(this.container);
            coordinateGenerator.generateCoordinates();
            this.container = coordinateGenerator.getMolecule();
        }
        catch (CDKException e) {
            throw new ChemkitException(e.getMessage(), (Throwable)e);
        }
    }

    public void prepareForBuild(ChemicalImpl.PreparationOptions options) {
        try {
            this.perceiveAtomTypesOfNonQueryAtoms.get();
            if (options.makeHydrogensExplicit) {
                this.makeHydrogensExplicit();
            } else {
                this.hydrogenAdder.addImplicitHydrogens(this.container);
            }
            if (options.aromatize) {
                this.aromatize();
            } else {
                this.kekulize();
            }
            if (options.computeCoords) {
                StructureDiagramGenerator coordinateGenerator = new StructureDiagramGenerator(this.container);
                coordinateGenerator.generateCoordinates();
                this.container = coordinateGenerator.getMolecule();
            }
            if (options.computeStereo) {
                boolean has2dCoords = true;
                boolean has3dCoords = true;
                for (IAtom atom : this.container.atoms()) {
                    if (atom.getPoint3d() == null) {
                        has3dCoords = false;
                    }
                    if (atom.getPoint2d() != null) continue;
                    has2dCoords = false;
                }
                StereoElementFactory stereoElementFactory = has3dCoords ? StereoElementFactory.using3DCoordinates((IAtomContainer)this.container) : StereoElementFactory.using2DCoordinates((IAtomContainer)this.container);
                List stereo = stereoElementFactory.createAll();
                this.container.setStereoElements(stereo);
            }
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
    }

    static int aromStatus(IAtomContainer mol) {
        int res = 0;
        for (IAtom atom : mol.atoms()) {
            if (atom.getImplicitHydrogenCount() != null || !atom.getFlag(32)) continue;
            if (atom.getAtomicNumber() == 7 || atom.getAtomicNumber() == 15) {
                res = 2;
                continue;
            }
            if (res >= 2) continue;
            res = 1;
        }
        return res;
    }

    public void kekulize() {
        this.isAromatic = false;
        try {
            Kekulization.kekulize((IAtomContainer)this.container);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
    }

    public String getFormula() {
        return this.getFormula(true);
    }

    public String getFormula(boolean includeImplicitHydrogen) {
        IMolecularFormula formula = (IMolecularFormula)this.container.getBuilder().newInstance(IMolecularFormula.class, new Object[0]);
        int charge = 0;
        IAtom hAtom = null;
        for (IAtom iAtom : this.container.atoms()) {
            formula.addIsotope((IIsotope)iAtom);
            if (iAtom.getFormalCharge() != null) {
                charge += iAtom.getFormalCharge().intValue();
            }
            if (!includeImplicitHydrogen || iAtom.getImplicitHydrogenCount() == null || iAtom.getImplicitHydrogenCount() <= 0) continue;
            if (hAtom == null) {
                hAtom = (IAtom)this.container.getBuilder().newInstance(IAtom.class, new Object[]{"H"});
            }
            formula.addIsotope(hAtom, iAtom.getImplicitHydrogenCount().intValue());
        }
        formula.setCharge(Integer.valueOf(charge));
        return MolecularFormulaManipulator.getString((IMolecularFormula)formula);
    }

    public List<ExtendedTetrahedralChirality> getExtendedTetrahedrals() {
        ArrayList<ExtendedTetrahedralChirality> list = new ArrayList<ExtendedTetrahedralChirality>();
        this.cahnIngoldPrelogSupplier.get();
        for (IStereoElement se : this.container.stereoElements()) {
            if (!(se instanceof ExtendedTetrahedral)) continue;
            list.add(new CdkExtendedTetrahedralChirality((ExtendedTetrahedral)se));
        }
        return list;
    }

    public List<TetrahedralChirality> getTetrahedrals() {
        ArrayList<TetrahedralChirality> list = new ArrayList<TetrahedralChirality>();
        this.cahnIngoldPrelogSupplier.get();
        for (IStereoElement se : this.container.stereoElements()) {
            if (!(se instanceof ITetrahedralChirality)) continue;
            ITetrahedralChirality chirality = (ITetrahedralChirality)se;
            list.add(new CdkTetrahedralChirality(chirality));
        }
        return list;
    }

    public Bond addBond(Bond b) {
        IBond ibond = CdkBond.getIBondFor(b);
        this.container.addBond(ibond);
        this.setDirty();
        return this.getCdkBondFor(ibond);
    }

    public List<SGroup> getSGroups() {
        List sgroups = (List)this.container.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups == null) {
            return Collections.emptyList();
        }
        ArrayList<SGroup> chemkitGroups = new ArrayList<SGroup>();
        for (Sgroup group : sgroups) {
            chemkitGroups.add(new CDKSgroupAdapter(group));
        }
        return chemkitGroups;
    }

    public void removeSGroup(SGroup sgroup) {
        List sgroups = (List)this.container.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups == null) {
            return;
        }
        sgroups.remove(((CDKSgroupAdapter)sgroup).sgroup);
    }

    public SGroup addSgroup(SGroup.SGroupType type) {
        SGroup.SGroupType typeToUse = type == null ? SGroup.SGroupType.GENERIC : type;
        ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)this.container.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups == null) {
            sgroups = new ArrayList<Sgroup>();
            this.container.setProperty((Object)"cdk:CtabSgroups", sgroups);
        }
        Sgroup cdkSgroup = new Sgroup();
        cdkSgroup.setType(SgroupType.parseCtabKey((String)typeToUse.getTypeName()));
        sgroups.add(cdkSgroup);
        return new CDKSgroupAdapter(cdkSgroup);
    }

    public boolean hasSGroups() {
        Set sgroups = (Set)this.container.getProperty((Object)"cdk:CtabSgroups");
        return sgroups != null && !sgroups.isEmpty();
    }

    public Bond addBond(Atom atom1, Atom atom2, Bond.BondType type) {
        IBond.Order order = null;
        switch (type) {
            case SINGLE: {
                order = IBond.Order.SINGLE;
                break;
            }
            case DOUBLE: {
                order = IBond.Order.DOUBLE;
                break;
            }
            case TRIPLE: {
                order = IBond.Order.TRIPLE;
                break;
            }
            case QUADRUPLE: {
                order = IBond.Order.QUADRUPLE;
                break;
            }
            case AROMATIC: {
                order = IBond.Order.SINGLE;
            }
        }
        int index1 = this.indexOf(atom1);
        int index2 = this.indexOf(atom2);
        IBond bond = (IBond)this.container.getBuilder().newInstance(IBond.class, new Object[]{this.container.getAtom(index1), this.container.getAtom(index2), order});
        if (type == Bond.BondType.AROMATIC) {
            bond.getBegin().setFlag(32, true);
            bond.getEnd().setFlag(32, true);
            bond.setFlag(32, true);
        }
        this.container.addBond(bond);
        this.setImplicitHydrogens(((CdkAtom)atom1).getAtom());
        this.setImplicitHydrogens(((CdkAtom)atom2).getAtom());
        this.setDirty();
        return this.getCdkBondFor(bond);
    }

    protected void setImplicitHydrogens() {
        for (int i = 0; i < this.container.getAtomCount(); ++i) {
            this.setImplicitHydrogens(this.container.getAtom(i));
        }
    }

    protected int setImplicitHydrogens(IAtom atom) {
        try {
            CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)SilentChemObjectBuilder.getInstance());
            IAtomType type = matcher.findMatchingAtomType(this.container, atom);
            AtomTypeManipulator.configure((IAtom)atom, (IAtomType)type);
            Integer neighborCount = atom.getFormalNeighbourCount();
            if (neighborCount == null) {
                neighborCount = 0;
            }
            int implicitH = neighborCount;
            for (IBond bond : this.container.getConnectedBondsList(atom)) {
                switch (bond.getOrder()) {
                    case SINGLE: {
                        --implicitH;
                        break;
                    }
                    case DOUBLE: {
                        implicitH -= 2;
                        break;
                    }
                    case TRIPLE: {
                        implicitH -= 3;
                        break;
                    }
                    case QUADRUPLE: {
                        implicitH -= 4;
                        break;
                    }
                    case QUINTUPLE: {
                        implicitH -= 5;
                        break;
                    }
                    case SEXTUPLE: {
                        implicitH -= 6;
                        break;
                    }
                }
            }
            atom.setImplicitHydrogenCount(Integer.valueOf(Math.max(0, implicitH)));
            return implicitH;
        }
        catch (CDKException e) {
            throw new RuntimeException("error computing implicit H count for atom " + atom, e);
        }
    }

    public Iterator<CdkChemicalImpl> connectedComponents() {
        final Iterator iter = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)this.container).atomContainers().iterator();
        return new Iterator<CdkChemicalImpl>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public CdkChemicalImpl next() {
                return new CdkChemicalImpl((IAtomContainer)iter.next(), CdkChemicalImpl.this.getSource());
            }
        };
    }

    public int indexOf(Atom a) {
        return this.container.indexOf(CdkAtom.getIAtomFor(a));
    }

    public int indexOf(Bond b) {
        return this.container.indexOf(CdkBond.getIBondFor(b));
    }

    public GraphInvariant getGraphInvariant() {
        int[][] g = GraphUtil.toAdjList((IAtomContainer)this.container);
        long[] inv = Canon.basicInvariants((IAtomContainer)this.container, (int[][])g);
        return new CdkGraphInvariant(inv);
    }

    public Bond getBond(int i) {
        return this.getCdkBondFor(this.container.getBond(i));
    }

    public BondTable getBondTable() {
        GraphUtil.EdgeToBondMap bondMap = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)this.container);
        GraphUtil.toAdjList((IAtomContainer)this.container, (GraphUtil.EdgeToBondMap)bondMap);
        return new CdkBondTable(bondMap);
    }

    private static Chirality convetCIPValueToChirality(IAtom center) {
        String value = (String)center.getProperty((Object)"cip.label");
        if ("S".equals(value)) {
            return Chirality.S;
        }
        if ("R".equals(value)) {
            return Chirality.R;
        }
        if ("NONE".equals(value)) {
            return Chirality.Non_Chiral;
        }
        System.out.println("stereo is not S or R but it's '" + value + "'");
        return Chirality.Unknown;
    }

    private static Chirality convertCdkStereoToChirality(ITetrahedralChirality.Stereo stereoType) {
        switch (stereoType) {
            case ANTI_CLOCKWISE: {
                return Chirality.S;
            }
            case CLOCKWISE: {
                return Chirality.R;
            }
        }
        return null;
    }

    public List<DoubleBondStereochemistry> getDoubleBondStereochemistry() {
        ArrayList<DoubleBondStereochemistry> list = new ArrayList<DoubleBondStereochemistry>();
        for (IStereoElement se : this.container.stereoElements()) {
            if (!(se instanceof IDoubleBondStereochemistry)) continue;
            IDoubleBondStereochemistry dbStereo = (IDoubleBondStereochemistry)se;
            list.add(new DoubleBondSeteochemistryImpl(dbStereo));
        }
        return list;
    }

    private static AtomCoordinates toCoordinates(Tuple2d tuple2d) {
        return AtomCoordinates.valueOf((double)tuple2d.x, (double)tuple2d.y);
    }

    public String getProperty(String key) {
        Object ret = this.container.getProperty((Object)key);
        if (ret == null) {
            return null;
        }
        return ret.toString();
    }

    public void setProperty(String key, String value) {
        this.container.setProperty((Object)key, (Object)value);
    }

    public Iterator<Map.Entry<String, String>> properties() {
        return new Iterator<Map.Entry<String, String>>(){
            Iterator<Map.Entry<Object, Object>> iter;
            {
                this.iter = CdkChemicalImpl.this.container.getProperties().entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                final Map.Entry<Object, Object> next = this.iter.next();
                return new Map.Entry<String, String>(){

                    @Override
                    public String setValue(String value) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public String getValue() {
                        Object v = next.getValue();
                        if (v == null) {
                            return null;
                        }
                        return v.toString();
                    }

                    @Override
                    public String getKey() {
                        return next.getKey().toString();
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private class DoubleBondSeteochemistryImpl
    implements DoubleBondStereochemistry {
        private final IBond stereoBond;
        private final IBond doubleBond;
        private final IAtom[] ligands;
        private final DoubleBondStereochemistry.DoubleBondStereo stereo;
        private final IDoubleBondStereochemistry dbStereo;

        public DoubleBondSeteochemistryImpl(IDoubleBondStereochemistry dbStereo) {
            this.dbStereo = dbStereo;
            IBond[] surroundingBonds = dbStereo.getBonds();
            if (surroundingBonds[0] == null || surroundingBonds[1] == null) {
                throw new RuntimeException("Cannot generate an InChI with incomplete double bond info");
            }
            IDoubleBondStereochemistry.Conformation stereoType = dbStereo.getStereo();
            this.stereo = stereoType == IDoubleBondStereochemistry.Conformation.TOGETHER ? DoubleBondStereochemistry.DoubleBondStereo.Z_CIS : (stereoType == IDoubleBondStereochemistry.Conformation.OPPOSITE ? DoubleBondStereochemistry.DoubleBondStereo.E_TRANS : DoubleBondStereochemistry.DoubleBondStereo.E_OR_Z);
            this.stereoBond = dbStereo.getStereoBond();
            this.ligands = new IAtom[4];
            if (this.stereoBond.contains(surroundingBonds[0].getAtom(0))) {
                this.ligands[1] = surroundingBonds[0].getAtom(0);
                this.ligands[0] = surroundingBonds[0].getAtom(1);
            } else {
                this.ligands[0] = surroundingBonds[0].getAtom(0);
                this.ligands[1] = surroundingBonds[0].getAtom(1);
            }
            if (this.stereoBond.contains(surroundingBonds[1].getAtom(0))) {
                this.ligands[2] = surroundingBonds[1].getAtom(0);
                this.ligands[3] = surroundingBonds[1].getAtom(1);
            } else {
                this.ligands[2] = surroundingBonds[1].getAtom(1);
                this.ligands[3] = surroundingBonds[1].getAtom(0);
            }
            this.doubleBond = CdkChemicalImpl.this.container.getBond(this.stereoBond.getAtom(0), this.stereoBond.getAtom(1));
        }

        public Bond getLigandBond(int i) {
            return CdkChemicalImpl.this.getCdkBondFor(this.dbStereo.getBonds()[i]);
        }

        private IBond findDoubleBond(IDoubleBondStereochemistry dbStereo) {
            for (IBond bond : dbStereo.getBonds()) {
                if (bond.getOrder() != IBond.Order.DOUBLE) continue;
                return bond;
            }
            throw new IllegalStateException("could not find double bond!!!");
        }

        public DoubleBondStereochemistry.DoubleBondStereo getStereo() {
            return this.stereo;
        }

        public Bond getDoubleBond() {
            return CdkChemicalImpl.this.getCdkBondFor(this.doubleBond);
        }

        public Atom getLigand(int i) {
            return CdkChemicalImpl.this.getCdkAtomFor(this.ligands[i]);
        }
    }

    private class SGroupBracketImpl
    implements SGroup.SGroupBracket {
        private final SgroupBracket bracket;

        public SGroupBracketImpl(SgroupBracket bracket) {
            this.bracket = bracket;
        }

        public AtomCoordinates getPoint1() {
            return CdkChemicalImpl.toCoordinates((Tuple2d)this.bracket.getFirstPoint());
        }

        public AtomCoordinates getPoint2() {
            return CdkChemicalImpl.toCoordinates((Tuple2d)this.bracket.getSecondPoint());
        }
    }

    private class CDKSgroupAdapter
    implements SGroup {
        private Sgroup sgroup;

        public CDKSgroupAdapter(Sgroup sgroup) {
            this.sgroup = sgroup;
        }

        public SGroup.SGroupType getType() {
            return SGroup.SGroupType.valueByTypeName((String)this.sgroup.getType().getKey());
        }

        public Stream<Atom> getAtoms() {
            return this.sgroup.getAtoms().stream().map(a -> CdkChemicalImpl.this.getCdkAtomFor((IAtom)a));
        }

        public Stream<Bond> getBonds() {
            return this.sgroup.getBonds().stream().map(b -> CdkChemicalImpl.this.getCdkBondFor((IBond)b));
        }

        public boolean bracketsTrusted() {
            return true;
        }

        public SGroup.SGroupConnectivity getConnectivity() {
            String value = (String)this.sgroup.getValue(SgroupKey.CtabConnectivity);
            return SGroup.SGroupConnectivity.parse((String)value);
        }

        public Stream<SGroup> getParentHierarchy() {
            return this.sgroup.getParents().stream().map(x$0 -> new CDKSgroupAdapter((Sgroup)x$0));
        }

        public Stream<Atom> getOutsideNeighbors() {
            Set sgroupAtoms = this.sgroup.getAtoms();
            HashSet<IAtom> outside = new HashSet<IAtom>();
            for (IAtom a2 : sgroupAtoms) {
                for (IAtom a22 : CdkChemicalImpl.this.container.getConnectedAtomsList(a2)) {
                    if (sgroupAtoms.contains(a22)) continue;
                    outside.add(a22);
                }
            }
            return outside.stream().map(a -> CdkChemicalImpl.this.getCdkAtomFor((IAtom)a));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.sgroup == null ? 0 : this.sgroup.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CDKSgroupAdapter)) {
                return false;
            }
            CDKSgroupAdapter other = (CDKSgroupAdapter)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.sgroup == null ? other.sgroup != null : !this.sgroup.equals(other.sgroup));
        }

        private CdkChemicalImpl getOuterType() {
            return CdkChemicalImpl.this;
        }

        public void addAtom(Atom a) {
            this.sgroup.addAtom(CdkAtom.getIAtomFor(a));
        }

        public void addBond(Bond b) {
            this.sgroup.addBond(CdkBond.getIBondFor(b));
        }

        public void removeAtom(Atom a) {
            this.sgroup.removeAtom(CdkAtom.getIAtomFor(a));
        }

        public void removeBond(Bond b) {
            this.sgroup.removeBond(CdkBond.getIBondFor(b));
        }

        public SGroup.PolymerSubType getPolymerSubType() {
            return SGroup.PolymerSubType.valueByCode((String)((String)this.sgroup.getValue(SgroupKey.CtabSubType)));
        }

        public void setPolymerSubType(SGroup.PolymerSubType polymerSubtype) {
            if (polymerSubtype == null) {
                this.sgroup.getAttributeKeys().remove(SgroupKey.CtabSubType);
            } else {
                this.sgroup.putValue(SgroupKey.CtabSubType, (Object)polymerSubtype.getCode());
            }
        }

        public boolean hasBrackets() {
            List brackets = (List)this.sgroup.getValue(SgroupKey.CtabBracket);
            return brackets != null && !brackets.isEmpty();
        }

        public List<SGroup.SGroupBracket> getBrackets() {
            List brackets = (List)this.sgroup.getValue(SgroupKey.CtabBracket);
            if (brackets == null) {
                return Collections.emptyList();
            }
            return brackets.stream().map(x$0 -> new SGroupBracketImpl((SgroupBracket)x$0)).collect(Collectors.toList());
        }

        public boolean bracketsSupported() {
            return true;
        }

        public Optional<String> getSubscript() {
            return Optional.ofNullable(this.sgroup.getSubscript());
        }

        public Optional<String> getSuperscript() {
            return Optional.ofNullable(this.sgroup.getSubscript());
        }
    }

    private class CdkTetrahedralChirality
    implements TetrahedralChirality {
        private final ITetrahedralChirality chirality;
        private final IAtom[] ligands;

        public CdkTetrahedralChirality(ITetrahedralChirality chirality) {
            this.chirality = chirality;
            this.ligands = chirality.getLigands();
        }

        public Atom getCenterAtom() {
            return CdkChemicalImpl.this.getCdkAtomFor(this.chirality.getChiralAtom());
        }

        public Chirality getChirality() {
            return CdkChemicalImpl.convetCIPValueToChirality(this.chirality.getChiralAtom());
        }

        public Atom getLigand(int i) {
            return CdkChemicalImpl.this.getCdkAtomFor(this.ligands[i]);
        }

        public List<Atom> getPeripheralAtoms() {
            ArrayList<Atom> atoms = new ArrayList<Atom>(4);
            atoms.add(this.getLigand(0));
            atoms.add(this.getLigand(1));
            atoms.add(this.getLigand(2));
            atoms.add(this.getLigand(3));
            return atoms;
        }
    }

    private class CdkExtendedTetrahedralChirality
    implements ExtendedTetrahedralChirality,
    CDKStereocenter {
        private List<Atom> terminalAtoms;
        private List<Atom> peripheralAtoms;
        private Atom centerAtom;
        private Chirality stereoType;

        public CdkExtendedTetrahedralChirality(ExtendedTetrahedral extendedTetrahedral) {
            this.terminalAtoms = this.toCdkAtomArray(extendedTetrahedral.findTerminalAtoms(CdkChemicalImpl.this.container));
            this.peripheralAtoms = this.toCdkAtomArray(extendedTetrahedral.peripherals());
            this.centerAtom = CdkChemicalImpl.this.getCdkAtomFor(extendedTetrahedral.focus());
            this.stereoType = CdkChemicalImpl.convertCdkStereoToChirality(extendedTetrahedral.winding());
        }

        @Override
        public Set<Stereocenters.Stereocenter> removeStereoCenterFrom(IAtomContainer container) {
            return null;
        }

        @Override
        public Stereocenter flip() {
            return null;
        }

        private List<Atom> toCdkAtomArray(IAtom[] as) {
            return Collections.unmodifiableList(Arrays.stream(as).map(CdkChemicalImpl.this::getCdkAtomFor).collect(Collectors.toList()));
        }

        public Chirality getChirality() {
            return this.stereoType;
        }

        public List<Atom> getTerminalAtoms() {
            return this.terminalAtoms;
        }

        public List<Atom> getPeripheralAtoms() {
            return this.peripheralAtoms;
        }

        public Atom getCenterAtom() {
            return this.centerAtom;
        }
    }

    static interface CDKStereocenter {
        public Set<Stereocenters.Stereocenter> removeStereoCenterFrom(IAtomContainer var1);

        public Stereocenter flip();
    }

    private class CdkBondTable
    implements BondTable {
        private final GraphUtil.EdgeToBondMap bondMap;

        public CdkBondTable(GraphUtil.EdgeToBondMap bondMap) {
            this.bondMap = bondMap;
        }

        public Bond getBond(int i, int j) {
            return CdkChemicalImpl.this.getCdkBondFor(this.bondMap.get(i, j));
        }

        public boolean bondExists(int i, int j) {
            return this.bondMap.get(i, j) != null;
        }

        public int getAtomCount() {
            return CdkChemicalImpl.this.getAtomCount();
        }
    }
}

