/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk;

import gov.nih.ncats.common.sneak.Sneak;
import gov.nih.ncats.molwitch.Atom;
import gov.nih.ncats.molwitch.Bond;
import gov.nih.ncats.molwitch.cdk.CdkAtom;
import gov.nih.ncats.molwitch.cdk.CdkChemicalImpl;
import org.openscience.cdk.BondRef;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;

public class CdkBond
implements Bond {
    private final IBond bond;
    private final CdkChemicalImpl parent;

    public CdkBond(IBond bond, CdkChemicalImpl parent) {
        this.bond = bond;
        this.parent = parent;
    }

    public void setBondType(Bond.BondType type) {
        switch (type) {
            case SINGLE: {
                this.bond.setOrder(IBond.Order.SINGLE);
                break;
            }
            case DOUBLE: {
                this.bond.setOrder(IBond.Order.DOUBLE);
                break;
            }
            case TRIPLE: {
                this.bond.setOrder(IBond.Order.TRIPLE);
                break;
            }
            case QUADRUPLE: {
                this.bond.setOrder(IBond.Order.QUADRUPLE);
                break;
            }
            case AROMATIC: {
                this.bond.setIsAromatic(true);
            }
        }
    }

    public boolean isQueryBond() {
        return BondRef.deref((IBond)this.bond) instanceof IQueryBond;
    }

    public Bond switchParity() {
        IBond clone = null;
        try {
            clone = this.bond.clone();
        }
        catch (CloneNotSupportedException e) {
            Sneak.sneakyThrow((Throwable)e);
        }
        clone.setOrder(this.toOrder(this.getBondType().switchParity()));
        return new CdkBond(clone, this.parent);
    }

    public Atom getOtherAtom(Atom a) {
        IAtom atom = ((CdkAtom)a).getAtom();
        IAtom other = this.bond.getOther(atom);
        return this.parent.getCdkAtomFor(other);
    }

    public Atom getAtom1() {
        IAtom atom = this.bond.getAtom(0);
        return this.parent.getCdkAtomFor(atom);
    }

    public Atom getAtom2() {
        IAtom atom = this.bond.getAtom(1);
        return this.parent.getCdkAtomFor(atom);
    }

    public Bond.BondType getBondType() {
        if (this.bond.isAromatic() && this.parent.isAromatic()) {
            return Bond.BondType.AROMATIC;
        }
        switch (this.bond.getOrder()) {
            case SINGLE: {
                return Bond.BondType.SINGLE;
            }
            case DOUBLE: {
                return Bond.BondType.DOUBLE;
            }
            case TRIPLE: {
                return Bond.BondType.TRIPLE;
            }
            case QUADRUPLE: {
                return Bond.BondType.QUADRUPLE;
            }
            case UNSET: {
                if (!this.bond.getAtom(0).isAromatic() || !this.bond.getAtom(1).isAromatic()) break;
                return Bond.BondType.AROMATIC;
            }
        }
        return null;
    }

    private IBond.Order toOrder(Bond.BondType type) {
        switch (type) {
            case SINGLE: {
                return IBond.Order.SINGLE;
            }
            case DOUBLE: {
                return IBond.Order.DOUBLE;
            }
            case TRIPLE: {
                return IBond.Order.TRIPLE;
            }
            case QUADRUPLE: {
                return IBond.Order.QUADRUPLE;
            }
        }
        return IBond.Order.DOUBLE;
    }

    IBond getBond() {
        return this.bond;
    }

    public Bond.Stereo getStereo() {
        IBond.Stereo cdkStereo = this.bond.getStereo();
        if (cdkStereo == null) {
            return null;
        }
        switch (cdkStereo) {
            case DOWN: {
                return Bond.Stereo.DOWN;
            }
            case DOWN_INVERTED: {
                return Bond.Stereo.DOWN_INVERTED;
            }
            case NONE: {
                return Bond.Stereo.NONE;
            }
            case UP: {
                return Bond.Stereo.UP;
            }
            case UP_INVERTED: {
                return Bond.Stereo.UP_INVERTED;
            }
            case UP_OR_DOWN: {
                return Bond.Stereo.UP_OR_DOWN;
            }
            case UP_OR_DOWN_INVERTED: {
                return Bond.Stereo.UP_OR_DOWN_INVERTED;
            }
        }
        return null;
    }

    public void setStereo(Bond.Stereo stereo) {
        if (stereo == null) {
            this.bond.setStereo(null);
            return;
        }
        switch (stereo) {
            case DOWN: {
                this.bond.setStereo(IBond.Stereo.DOWN);
                break;
            }
            case DOWN_INVERTED: {
                this.bond.setStereo(IBond.Stereo.DOWN_INVERTED);
                break;
            }
            case NONE: {
                this.bond.setStereo(IBond.Stereo.NONE);
                break;
            }
            case UP: {
                this.bond.setStereo(IBond.Stereo.UP);
                break;
            }
            case UP_INVERTED: {
                this.bond.setStereo(IBond.Stereo.UP_INVERTED);
                break;
            }
            case UP_OR_DOWN: {
                this.bond.setStereo(IBond.Stereo.UP_OR_DOWN);
                break;
            }
            case UP_OR_DOWN_INVERTED: {
                this.bond.setStereo(IBond.Stereo.UP_OR_DOWN_INVERTED);
            }
        }
    }

    public Bond.DoubleBondStereo getDoubleBondStereo() {
        if (this.getBondType() != Bond.BondType.DOUBLE) {
            return null;
        }
        this.parent.cahnIngoldPrelogSupplier.get();
        String value = (String)this.bond.getProperty((Object)"cip.label");
        if ("Z".equals(value)) {
            return Bond.DoubleBondStereo.Z_CIS;
        }
        if ("E".equals(value)) {
            return Bond.DoubleBondStereo.E_TRANS;
        }
        return Bond.DoubleBondStereo.NONE;
    }

    public boolean isAromatic() {
        return this.bond.isAromatic();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdkBond cdkBond = (CdkBond)o;
        if (!this.bond.equals(cdkBond.bond)) {
            return false;
        }
        return this.parent.equals(cdkBond.parent);
    }

    public int hashCode() {
        int result = this.bond.hashCode();
        result = 31 * result + this.parent.hashCode();
        return result;
    }

    public boolean isInRing() {
        this.parent.ringsSearcherSupplier.get();
        return this.bond.isInRing();
    }

    public static IBond getIBondFor(Bond b) {
        return ((CdkBond)b).bond;
    }
}

