/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.writer;

import gov.nih.ncats.molwitch.io.ChemFormat;
import gov.nih.ncats.molwitch.spi.ChemicalImpl;
import gov.nih.ncats.molwitch.spi.ChemicalWriterImpl;
import gov.nih.ncats.molwitch.spi.ChemicalWriterImplFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smarts.Smarts;

public class SmartsChemicalWriterFactory
implements ChemicalWriterImplFactory {
    public ChemicalWriterImpl newInstance(OutputStream out, ChemFormat.ChemFormatWriterSpecification spec) throws IOException {
        ChemFormat.SmartsFormatSpecification smartSpec = (ChemFormat.SmartsFormatSpecification)spec;
        return new SmartsWriterImpl(out);
    }

    public boolean supports(ChemFormat.ChemFormatWriterSpecification spec) {
        return spec instanceof ChemFormat.SmartsFormatSpecification;
    }

    private static class SmartsWriterImpl
    implements ChemicalWriterImpl {
        private final PrintWriter out;

        public SmartsWriterImpl(OutputStream out) {
            this.out = new PrintWriter(out);
        }

        public void write(ChemicalImpl chemicalImpl) throws IOException {
            Smarts.generate((IAtomContainer)((IAtomContainer)chemicalImpl.getWrappedObject()));
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

