/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.writer;

import gov.nih.ncats.molwitch.cdk.writer.CdkChemicalWriter;
import gov.nih.ncats.molwitch.spi.ChemicalImpl;
import java.io.IOException;
import org.openscience.cdk.io.IChemObjectWriter;

public class SingleCdkChemicalWriter
extends CdkChemicalWriter {
    private boolean writtenAlready = false;

    public SingleCdkChemicalWriter(IChemObjectWriter writer) {
        super(writer);
    }

    @Override
    public void write(ChemicalImpl impl) throws IOException {
        if (this.writtenAlready) {
            throw new OnlyOneChemicalAllowedException("already wrote a Chemical to this writer");
        }
        super.write(impl);
        this.writtenAlready = true;
    }

    private static class OnlyOneChemicalAllowedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public OnlyOneChemicalAllowedException(String message) {
            super(message);
        }
    }
}

