/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.writer;

import gov.nih.ncats.molwitch.cdk.writer.CdkChemicalWriter;
import gov.nih.ncats.molwitch.io.ChemFormat;
import gov.nih.ncats.molwitch.spi.ChemicalWriterImpl;
import gov.nih.ncats.molwitch.spi.ChemicalWriterImplFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.openscience.cdk.io.IChemObjectWriter;
import org.openscience.cdk.io.SDFWriter;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.listener.PropertiesListener;

public class SdfWriterFactory
implements ChemicalWriterImplFactory {
    public ChemicalWriterImpl newInstance(OutputStream out, ChemFormat.ChemFormatWriterSpecification spec) throws IOException {
        ChemFormat.SdfFormatSpecification sdfSpec = (ChemFormat.SdfFormatSpecification)spec;
        SDFWriter writer = new SDFWriter(out);
        if (sdfSpec.getMolSpec().getVersion() == ChemFormat.MolFormatSpecification.Version.V3000) {
            writer.setAlwaysV3000(true);
        }
        if (sdfSpec.getMolSpec().getKekulization() == ChemFormat.KekulizationEncoding.FORCE_AROMATIC) {
            Properties customSettings = new Properties();
            customSettings.setProperty("WriteAromaticBondTypes", Boolean.TRUE.toString());
            writer.addChemObjectIOListener((IChemObjectIOListener)new PropertiesListener(customSettings));
        }
        return new CdkChemicalWriter((IChemObjectWriter)writer);
    }

    public boolean supports(ChemFormat.ChemFormatWriterSpecification spec) {
        return "sdf".equals(spec.getFormatName()) && spec instanceof ChemFormat.SdfFormatSpecification;
    }
}

