/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.writer;

import gov.nih.ncats.molwitch.cdk.writer.AbstractMdlWriterFactory;
import gov.nih.ncats.molwitch.io.ChemFormat;
import java.io.IOException;
import java.io.OutputStream;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.IChemObjectWriter;
import org.openscience.cdk.io.MDLV3000Writer;

public class Mdl3000WriterFactory
extends AbstractMdlWriterFactory {
    @Override
    protected boolean supportsVersion(ChemFormat.MolFormatSpecification.Version version) {
        return version == ChemFormat.MolFormatSpecification.Version.V3000;
    }

    @Override
    protected IChemObjectWriter create(OutputStream out) throws IOException {
        try {
            return new MDLV3000Writer(out);
        }
        catch (CDKException e) {
            throw new IOException("error creating mol V3000 writer", e);
        }
    }
}

