/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.writer;

import gov.nih.ncats.molwitch.io.ChemFormat;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class CdkWriterOptionUtils {
    public static IAtomContainer createManipulatedContainer(ChemFormat.ChemFormatWriterSpecification spec, IAtomContainer container) {
        return CdkWriterOptionUtils.createManipulatedContainer(spec, container, false);
    }

    public static IAtomContainer createManipulatedContainer(ChemFormat.ChemFormatWriterSpecification spec, IAtomContainer container, boolean clonedContainer) {
        IAtomContainer ret = container;
        if (spec instanceof ChemFormat.HydrogenAwareChemFormatWriterSpecification) {
            switch (((ChemFormat.HydrogenAwareChemFormatWriterSpecification)spec).getHydrogenEncoding()) {
                case AS_IS: {
                    break;
                }
                case MAKE_IMPLICIT: {
                    ret = AtomContainerManipulator.removeHydrogens((IAtomContainer)ret);
                    break;
                }
                case MAKE_EXPLICIT: {
                    if (!clonedContainer) {
                        try {
                            ret = ret.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            throw new IllegalStateException("could not make clone", e);
                        }
                    }
                    AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)container);
                }
            }
        }
        return ret;
    }
}

