/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.writer;

import gov.nih.ncats.molwitch.io.ChemFormat;
import gov.nih.ncats.molwitch.spi.ChemicalImpl;
import gov.nih.ncats.molwitch.spi.ChemicalWriterImpl;
import gov.nih.ncats.molwitch.spi.ChemicalWriterImplFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.function.Function;
import org.jooq.lambda.Unchecked;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class CdkSmilesWriterFactory
implements ChemicalWriterImplFactory {
    public boolean supports(ChemFormat.ChemFormatWriterSpecification spec) {
        return spec instanceof ChemFormat.SmilesFormatWriterSpecification;
    }

    public ChemicalWriterImpl newInstance(OutputStream out, ChemFormat.ChemFormatWriterSpecification spec) throws IOException {
        ChemFormat.SmilesFormatWriterSpecification smilesSpec = (ChemFormat.SmilesFormatWriterSpecification)spec;
        int options = 0;
        if (smilesSpec.getCanonization() == ChemFormat.SmilesFormatWriterSpecification.CanonicalizationEncoding.CANONICAL) {
            options |= 1;
        }
        if (smilesSpec.getEncodeStereo() == ChemFormat.SmilesFormatWriterSpecification.StereoEncoding.INCLUDE_STEREO) {
            options |= 0x700;
        }
        if (smilesSpec.getKekulization() == ChemFormat.KekulizationEncoding.FORCE_AROMATIC) {
            options |= 0x10;
        }
        return new CdkSmilesWriter(out, options, smilesSpec.getHydrogenEncoding(), smilesSpec.getKekulization());
    }

    private static class CdkSmilesWriter
    implements ChemicalWriterImpl {
        private final PrintWriter out;
        private final SmilesGenerator sg;
        private final Function<IAtomContainer, IAtomContainer> modificationFunction;

        private static boolean hasImplicitH(IAtomContainer container) {
            for (IAtom atom : container.atoms()) {
                Integer implicitNum = atom.getImplicitHydrogenCount();
                if (implicitNum == null || implicitNum <= 0) continue;
                return true;
            }
            return false;
        }

        public CdkSmilesWriter(OutputStream out, int flavor, ChemFormat.HydrogenEncoding hydrogenEncoding, ChemFormat.KekulizationEncoding aromaticEncoding) {
            this.out = new PrintWriter(out);
            this.sg = new SmilesGenerator(flavor);
            this.modificationFunction = hydrogenEncoding == ChemFormat.HydrogenEncoding.MAKE_EXPLICIT ? Unchecked.function(container -> {
                if (CdkSmilesWriter.hasImplicitH(container)) {
                    IAtomContainer copy = container.clone();
                    AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)copy);
                    if (aromaticEncoding == ChemFormat.KekulizationEncoding.FORCE_AROMATIC) {
                        new Aromaticity(ElectronDonation.daylight(), Cycles.all()).apply(copy);
                    }
                    return copy;
                }
                return container;
            }) : (hydrogenEncoding == ChemFormat.HydrogenEncoding.MAKE_IMPLICIT ? Unchecked.function(container -> {
                IAtomContainer copy = container.clone();
                AtomContainerManipulator.suppressHydrogens((IAtomContainer)copy);
                if (aromaticEncoding == ChemFormat.KekulizationEncoding.FORCE_AROMATIC) {
                    boolean alreadyMarkedAromatic = false;
                    for (IAtom a : copy.atoms()) {
                        if (!a.isAromatic()) continue;
                        alreadyMarkedAromatic = true;
                        break;
                    }
                    if (!alreadyMarkedAromatic) {
                        new Aromaticity(ElectronDonation.daylight(), Cycles.all()).apply(copy);
                    }
                }
                return copy;
            }) : (aromaticEncoding == ChemFormat.KekulizationEncoding.FORCE_AROMATIC ? Unchecked.function(container -> {
                boolean alreadyMarkedAromatic = false;
                for (IAtom a : container.atoms()) {
                    if (!a.isAromatic()) continue;
                    alreadyMarkedAromatic = true;
                    break;
                }
                if (alreadyMarkedAromatic) {
                    return container;
                }
                IAtomContainer copy = container.clone();
                new Aromaticity(ElectronDonation.daylight(), Cycles.all()).apply(copy);
                return copy;
            }) : Function.identity()));
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void write(ChemicalImpl chemicalImpl) throws IOException {
            try {
                this.out.println(this.sg.create(this.modificationFunction.apply((IAtomContainer)chemicalImpl.getWrappedObject())));
            }
            catch (CDKException e) {
                throw new IOException("error writing out smiles for " + chemicalImpl.getName(), e);
            }
        }
    }
}

