/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.fingerprinters;

import gov.nih.ncats.molwitch.Chemical;
import gov.nih.ncats.molwitch.fingerprint.Fingerprint;
import gov.nih.ncats.molwitch.fingerprint.Fingerprinter;
import java.util.ArrayList;
import java.util.Iterator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

class FingerprinterAdapter
implements Fingerprinter {
    private final IFingerprinter delegate;

    public FingerprinterAdapter(IFingerprinter impl) {
        this.delegate = impl;
    }

    public Fingerprint computeFingerprint(Chemical chemical) {
        IAtomContainer orig;
        IAtomContainer container = orig = (IAtomContainer)chemical.getImpl().getWrappedObject();
        try {
            IAtomContainer clone = orig.clone();
            ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
            int i = 0;
            for (IAtom next : clone.atoms()) {
                if (next.getSymbol() == null) {
                    indexesToRemove.add(i);
                }
                ++i;
            }
            for (int k = indexesToRemove.size() - 1; k >= 0; --k) {
                clone.removeAtom(k);
            }
            Iterator bondIter = clone.bonds().iterator();
            while (bondIter.hasNext()) {
                IAtom next;
                next = (IBond)bondIter.next();
                if (next.getOrder() != null) continue;
                bondIter.remove();
            }
            container = clone;
        }
        catch (CloneNotSupportedException e1) {
            throw new IllegalStateException(e1);
        }
        try {
            return new Fingerprint(this.delegate.getBitFingerprint(container).asBitSet());
        }
        catch (CDKException e) {
            throw new RuntimeException(e);
        }
    }
}

