/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk.fingerprinters;

import gov.nih.ncats.molwitch.cdk.fingerprinters.FingerprinterAdapter;
import gov.nih.ncats.molwitch.fingerprint.Fingerprinter;
import gov.nih.ncats.molwitch.fingerprint.Fingerprinters;
import gov.nih.ncats.molwitch.spi.FingerprinterImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.fingerprint.CircularFingerprinter;
import org.openscience.cdk.fingerprint.IFingerprinter;

public class EcfpFingerPrinter
implements FingerprinterImpl {
    private static List<String> supportedAlgorithms = Arrays.asList(Fingerprinters.FingerprintSpecification.ECFP.name(), Fingerprinters.FingerprintSpecification.FCFP.name());

    public boolean supports(Fingerprinters.FingerprintSpecification options) {
        return supportedAlgorithms.contains(options.name());
    }

    public boolean isDefault() {
        return false;
    }

    public Set<String> getSupportedAlgorithmNames() {
        return Collections.unmodifiableSet(new HashSet<String>(supportedAlgorithms));
    }

    public Fingerprinter createFingerPrinterFor(Fingerprinters.FingerprintSpecification fingerPrinterOptions) {
        int classType;
        Fingerprinters.AbstractCfpOptions ecfpOptions = (Fingerprinters.AbstractCfpOptions)fingerPrinterOptions;
        int diameter = ecfpOptions.getDiameter();
        if (ecfpOptions instanceof Fingerprinters.EcfpSpecification) {
            switch (diameter) {
                case 0: {
                    classType = 1;
                    break;
                }
                case 2: {
                    classType = 2;
                    break;
                }
                case 4: {
                    classType = 3;
                    break;
                }
                default: {
                    classType = 4;
                    break;
                }
            }
        } else {
            switch (diameter) {
                case 0: {
                    classType = 5;
                    break;
                }
                case 2: {
                    classType = 6;
                    break;
                }
                case 4: {
                    classType = 7;
                    break;
                }
                default: {
                    classType = 8;
                }
            }
        }
        return new FingerprinterAdapter((IFingerprinter)new CircularFingerprinter(classType, ecfpOptions.getBitLength()));
    }
}

