/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk;

import gov.nih.ncats.molwitch.cdk.CdkChemical2FactoryImpl;
import gov.nih.ncats.molwitch.cdk.IdAwareSdfReader;
import gov.nih.ncats.molwitch.cdk.ProgramClearingMol2000Wrapper;
import gov.nih.ncats.molwitch.cdk.QueryAtomPerceptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.FormatFactory;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.io.formats.SDFFormat;
import org.openscience.cdk.io.formats.SMARTSFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.iterator.IIteratingChemObjectReader;
import org.openscience.cdk.io.iterator.IteratingSMILESReader;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smarts.Smarts;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class ReaderFactory {
    public static GuessResult guessReaderFor(BufferedReader reader) throws IOException {
        IResourceFormat format;
        try {
            format = new FormatFactory().guessFormat((Reader)reader);
        }
        catch (Throwable e) {
            format = SMILESFormat.getInstance();
        }
        if (format == null) {
            format = SMILESFormat.getInstance();
        }
        return ReaderFactory.create(reader, format);
    }

    public static GuessResult create(BufferedReader reader, IResourceFormat format) throws IOException {
        if (format instanceof MDLV2000Format || format instanceof MDLV3000Format) {
            CdkChemical2FactoryImpl.SavedBufferedReader savedReader = new CdkChemical2FactoryImpl.SavedBufferedReader(new ProgramClearingMol2000Wrapper(reader));
            return new GuessResult((IIteratingChemObjectReader<IAtomContainer>)new IdAwareSdfReader(savedReader, SilentChemObjectBuilder.getInstance()), savedReader);
        }
        if (format instanceof SMILESFormat) {
            CdkChemical2FactoryImpl.SavedBufferedReader savedReader = new CdkChemical2FactoryImpl.SavedBufferedReader(reader);
            return new GuessResult((IIteratingChemObjectReader<IAtomContainer>)new IteratingSMILESReader((Reader)savedReader, SilentChemObjectBuilder.getInstance()), savedReader);
        }
        if (format instanceof SMARTSFormat) {
            CdkChemical2FactoryImpl.SavedBufferedReader savedReader = new CdkChemical2FactoryImpl.SavedBufferedReader(reader);
            return new GuessResult((IIteratingChemObjectReader<IAtomContainer>)new IteratingSmartsReader(savedReader, SilentChemObjectBuilder.getInstance()), savedReader);
        }
        if (format instanceof SDFFormat) {
            CdkChemical2FactoryImpl.SavedBufferedReader savedReader = new CdkChemical2FactoryImpl.SavedBufferedReader(new ProgramClearingMol2000Wrapper(reader));
            return new GuessResult((IIteratingChemObjectReader<IAtomContainer>)new IdAwareSdfReader(savedReader, SilentChemObjectBuilder.getInstance()), savedReader);
        }
        throw new IOException("not configured to parse " + format.getFormatName());
    }

    static class IteratingSmartsReader
    extends DefaultIteratingChemObjectReader<IAtomContainer> {
        private BufferedReader input;
        private IAtomContainer nextMolecule;
        private boolean nextAvailableIsKnown;
        private boolean hasNext;
        private final IChemObjectBuilder builder;

        public IteratingSmartsReader(Reader in, IChemObjectBuilder builder) {
            this.setReader(in);
            this.builder = builder;
        }

        public IteratingSmartsReader(InputStream in, IChemObjectBuilder builder) {
            this(new InputStreamReader(in), builder);
        }

        public boolean hasNext() {
            if (!this.nextAvailableIsKnown) {
                this.hasNext = false;
                try {
                    String line = this.input.readLine();
                    if (line == null) {
                        this.nextAvailableIsKnown = true;
                        return false;
                    }
                    this.hasNext = true;
                    IAtomContainer container = this.builder.newAtomContainer();
                    Smarts.parse((IAtomContainer)container, (String)line);
                    AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)container);
                    QueryAtomPerceptor.percieve(container);
                    this.nextMolecule = container;
                }
                catch (Exception var3) {
                    this.hasNext = false;
                }
                if (!this.hasNext) {
                    this.nextMolecule = null;
                }
                this.nextAvailableIsKnown = true;
            }
            return this.hasNext;
        }

        public IAtomContainer next() {
            if (!this.nextAvailableIsKnown) {
                this.hasNext();
            }
            this.nextAvailableIsKnown = false;
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            return this.nextMolecule;
        }

        public void close() throws IOException {
            if (this.input != null) {
                this.input.close();
            }
        }

        public void setReader(Reader reader) {
            this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.nextMolecule = null;
            this.nextAvailableIsKnown = false;
            this.hasNext = false;
        }

        public void setReader(InputStream reader) {
            this.setReader(new InputStreamReader(reader));
        }

        public IResourceFormat getFormat() {
            return SMARTSFormat.getInstance();
        }
    }

    static class GuessResult {
        public final IIteratingChemObjectReader<IAtomContainer> cdkReader;
        public final CdkChemical2FactoryImpl.SavedBufferedReader savedBufferedReader;

        public GuessResult(IIteratingChemObjectReader<IAtomContainer> cdkReader, CdkChemical2FactoryImpl.SavedBufferedReader savedBufferedReader) {
            this.cdkReader = cdkReader;
            this.savedBufferedReader = savedBufferedReader;
        }
    }
}

