/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk;

import gov.nih.ncats.common.io.InputStreamSupplier;
import gov.nih.ncats.molwitch.ChemicalSource;
import gov.nih.ncats.molwitch.SmartsSource;
import gov.nih.ncats.molwitch.SmilesSource;
import gov.nih.ncats.molwitch.cdk.CdkChemicalImpl;
import gov.nih.ncats.molwitch.cdk.CdkUtil;
import gov.nih.ncats.molwitch.cdk.QueryAtomPerceptor;
import gov.nih.ncats.molwitch.cdk.ReaderFactory;
import gov.nih.ncats.molwitch.internal.source.MolStringSource;
import gov.nih.ncats.molwitch.spi.ChemicalImpl;
import gov.nih.ncats.molwitch.spi.ChemicalImplFactory;
import gov.nih.ncats.molwitch.spi.ChemicalImplReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.formats.SDFFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.io.iterator.IIteratingChemObjectReader;
import org.openscience.cdk.io.iterator.IteratingSDFReader;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.smarts.Smarts;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class CdkChemical2FactoryImpl
implements ChemicalImplFactory {
    private SmilesParser preserveAromaticSmilesParser = new SmilesParser(CdkUtil.getChemObjectBuilder());
    private SmilesParser kekuleSmilesParser;

    public CdkChemical2FactoryImpl() {
        this.preserveAromaticSmilesParser.kekulise(false);
        this.kekuleSmilesParser = new SmilesParser(CdkUtil.getChemObjectBuilder());
    }

    public ChemicalImpl createNewEmptyChemical() {
        return new CdkChemicalImpl(CdkUtil.getChemObjectBuilder().newAtomContainer(), (ChemicalSource)null);
    }

    private IAtomContainer createIAtomContainerFrom(String smiles) throws Exception {
        IAtomContainer mol = this.tryCreate(smiles);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)mol);
        StructureDiagramGenerator coordinateGenerator = new StructureDiagramGenerator(mol);
        coordinateGenerator.generateExperimentalCoordinates();
        mol = coordinateGenerator.getMolecule();
        return mol;
    }

    private IAtomContainer tryCreate(String smiles) throws InvalidSmilesException {
        try {
            return this.kekuleSmilesParser.parseSmiles(smiles);
        }
        catch (InvalidSmilesException e) {
            return this.preserveAromaticSmilesParser.parseSmiles(smiles);
        }
    }

    protected void addImplicitHydrogens(IAtomContainer container) throws Exception {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)container.getBuilder());
        int atomCount = container.getAtomCount();
        String[] originalAtomTypeNames = new String[atomCount];
        for (int i = 0; i < atomCount; ++i) {
            IAtom atom = container.getAtom(i);
            IAtomType type = matcher.findMatchingAtomType(container, atom);
            originalAtomTypeNames[i] = atom.getAtomTypeName();
            atom.setAtomTypeName(type.getAtomTypeName());
        }
        CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)container.getBuilder());
        hAdder.addImplicitHydrogens(container);
        for (int i = 0; i < atomCount; ++i) {
            IAtom atom = container.getAtom(i);
            atom.setAtomTypeName(originalAtomTypeNames[i]);
        }
    }

    public ChemicalImpl createFromSmiles(String smiles) throws IOException {
        try {
            IAtomContainer container = this.createIAtomContainerFrom(smiles);
            CdkChemicalImpl chem = new CdkChemicalImpl(container, (ChemicalSource)new SmilesSource(smiles));
            return chem;
        }
        catch (Exception e) {
            throw new IOException("error parsing smiles : " + smiles, e);
        }
    }

    public ChemicalImpl create(String unknownFormattedInput) throws IOException {
        if (new BufferedReader(new StringReader(unknownFormattedInput.trim())).lines().count() == 1L) {
            if (unknownFormattedInput.indexOf(126) > -1 || unknownFormattedInput.indexOf(42) > -1) {
                return this.createFromSmarts(unknownFormattedInput);
            }
            return this.createFromSmiles(unknownFormattedInput);
        }
        try (ChemicalImplReader reader = this.createFrom(new BufferedReader(new StringReader(unknownFormattedInput)), null);){
            ChemicalImpl chemicalImpl = reader.read();
            return chemicalImpl;
        }
    }

    public boolean isFormatAgnostic() {
        return true;
    }

    public ChemicalImpl createFromSmarts(String smarts) throws IOException {
        try {
            IAtomContainer container = CdkUtil.getChemObjectBuilder().newAtomContainer();
            Smarts.parse((IAtomContainer)container, (String)smarts);
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)container);
            QueryAtomPerceptor.percieve(container);
            return new CdkChemicalImpl(container, (ChemicalSource)new SmartsSource(smarts));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("error parsing smarts : '" + smarts + "' reason = " + Smarts.getLastErrorMesg(), e);
        }
    }

    public ChemicalImplReader create(byte[] molBytes, int start, int length) throws IOException {
        return this.create(new ByteArrayInputStream(molBytes, start, length));
    }

    public ChemicalImplReader create(String format, InputStreamSupplier in) throws IOException {
        return this.createFrom(this.computeFormatFromString(format), new InputStreamReader(in.get()), null);
    }

    public ChemicalImplReader create(InputStreamSupplier in) throws IOException {
        return this.create(in.get());
    }

    public ChemicalImplReader create(String format, InputStream in) throws IOException {
        return this.createFrom(this.computeFormatFromString(format), new InputStreamReader(in), null);
    }

    private IChemFormat computeFormatFromString(String format) {
        if (format == null) {
            return null;
        }
        if ("SMILES".equalsIgnoreCase(format)) {
            return (IChemFormat)SMILESFormat.getInstance();
        }
        if ("mol".equalsIgnoreCase(format)) {
            return (IChemFormat)MDLV2000Format.getInstance();
        }
        if ("sdf".equalsIgnoreCase(format)) {
            return (IChemFormat)SDFFormat.getInstance();
        }
        return null;
    }

    public ChemicalImplReader create(String format, File file) throws IOException {
        return this.createFrom(this.computeFormatFromString(format), new InputStreamReader(InputStreamSupplier.forFile((File)file).get()), source -> {
            source.getProperties().put("Filename", file.getName());
            source.getProperties().put("Filepath", file.getAbsolutePath());
            source.getProperties().put("Filesize", Long.toString(file.length()));
        });
    }

    public boolean supports(String format) {
        return "SMILES".equalsIgnoreCase(format) || "mol".equalsIgnoreCase(format) || "sdf".equalsIgnoreCase(format);
    }

    public ChemicalImplReader create(File file) throws IOException {
        return this.createFrom(new InputStreamReader(InputStreamSupplier.forFile((File)file).get()), source -> {
            source.getProperties().put("Filename", file.getName());
            source.getProperties().put("Filepath", file.getAbsolutePath());
            source.getProperties().put("Filesize", Long.toString(file.length()));
        });
    }

    private ChemicalImplReader createFrom(Reader reader, Consumer<ChemicalSource> sourceConsumer) throws IOException {
        ReaderFactory.GuessResult guessedReader = ReaderFactory.guessReaderFor(new BufferedReader(reader));
        return new CdkChemicalImplReader(guessedReader.cdkReader, guessedReader.savedBufferedReader, sourceConsumer);
    }

    private ChemicalImplReader createFrom(IChemFormat format, Reader reader, Consumer<ChemicalSource> sourceConsumer) throws IOException {
        ReaderFactory.GuessResult guessedReader = ReaderFactory.create(new BufferedReader(reader), (IResourceFormat)format);
        return new CdkChemicalImplReader(guessedReader.cdkReader, guessedReader.savedBufferedReader, sourceConsumer);
    }

    public ChemicalImplReader create(InputStream in) throws IOException {
        return this.createFrom(new InputStreamReader(in), null);
    }

    public boolean isDefault() {
        return true;
    }

    static class SavedBufferedReader
    extends BufferedReader {
        private final StringBuilder buffer = new StringBuilder(2048);
        private final String NEW_LINE = System.lineSeparator();
        private int resetPosition = -1;
        BufferedReader reader;

        public SavedBufferedReader(BufferedReader in) {
            super(in);
            this.reader = in;
        }

        @Override
        public String readLine() throws IOException {
            String line = this.reader.readLine();
            if (line != null) {
                this.buffer.append(line).append(this.NEW_LINE);
            }
            return line;
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.resetPosition = this.buffer.length();
            this.reader.mark(readAheadLimit);
        }

        @Override
        public void reset() throws IOException {
            this.reader.reset();
            this.buffer.setLength(this.resetPosition);
            this.resetPosition = -1;
        }

        public String getBufferedLines() {
            return this.buffer.toString();
        }

        public void resetBuffer() {
            this.buffer.setLength(0);
        }

        @Override
        public int read() throws IOException {
            return this.reader.read();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.reader.read(cbuf, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.reader.skip(n);
        }

        @Override
        public boolean ready() throws IOException {
            return this.reader.ready();
        }

        @Override
        public boolean markSupported() {
            return this.reader.markSupported();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public Stream<String> lines() {
            return this.reader.lines();
        }
    }

    private static class CdkChemicalImplReader
    implements ChemicalImplReader {
        private final IIteratingChemObjectReader<IAtomContainer> iter;
        private final SavedBufferedReader savedReader;
        private ChemicalSource.Type type;
        boolean alreadyReadFirstRecord = false;
        private Consumer<ChemicalSource> sourceConsumer;

        public CdkChemicalImplReader(IIteratingChemObjectReader<IAtomContainer> iter, SavedBufferedReader savedReader, Consumer<ChemicalSource> sourceConsumer) {
            this.iter = iter;
            this.savedReader = savedReader;
            this.sourceConsumer = sourceConsumer;
            this.type = iter instanceof IteratingSDFReader ? ChemicalSource.Type.SDF : ChemicalSource.Type.SMILES;
        }

        public void close() throws IOException {
            this.iter.close();
        }

        public ChemicalImpl read() throws IOException {
            if (this.iter.hasNext()) {
                try {
                    ChemicalSource source;
                    CdkChemicalImpl impl = new CdkChemicalImpl((IAtomContainer)this.iter.next(), () -> {
                        String data = this.savedReader.getBufferedLines();
                        if (this.type == ChemicalSource.Type.SMILES) {
                            return new SmilesSource(data.trim());
                        }
                        if (!this.alreadyReadFirstRecord) {
                            this.type = data.contains("$$$$") ? ChemicalSource.Type.SDF : ChemicalSource.Type.MOL;
                        }
                        this.alreadyReadFirstRecord = true;
                        return new MolStringSource(data, this.type);
                    });
                    this.savedReader.resetBuffer();
                    if (this.sourceConsumer != null && (source = impl.getSource()) != null) {
                        this.sourceConsumer.accept(source);
                    }
                    return impl;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.out.println("problem record\n=======\n" + this.savedReader.getBufferedLines() + "\n=======");
                    throw e;
                }
            }
            return null;
        }
    }
}

