/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.molwitch.cdk;

import gov.nih.ncats.molwitch.Atom;
import gov.nih.ncats.molwitch.AtomCoordinates;
import gov.nih.ncats.molwitch.Bond;
import gov.nih.ncats.molwitch.Chirality;
import gov.nih.ncats.molwitch.cdk.CdkChemicalImpl;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.SingleElectron;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.RGroupQuery;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import uk.ac.ebi.beam.Element;

public class CdkAtom
implements Atom {
    private static IsotopeFactory isotopeFactory;
    private IAtom atom;
    private CdkChemicalImpl parent;

    public static IAtom getIAtomFor(Atom a) {
        return ((CdkAtom)a).atom;
    }

    public CdkAtom(IAtom atom, CdkChemicalImpl parent) {
        Objects.requireNonNull(atom);
        this.parent = parent;
        this.atom = atom;
    }

    public boolean isValidAtomicSymbol() {
        return Element.ofSymbol((String)this.getSymbol()) != null;
    }

    public int getSmallestRingSize() {
        this.parent.ringsSearcherSupplier.get();
        if (!this.atom.isInRing()) {
            return 0;
        }
        IRingSet ringSet = Cycles.sssr((IAtomContainer)((IAtomContainer)this.parent.getWrappedObject())).toRingSet();
        if (!ringSet.contains(this.atom)) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        for (IAtomContainer r : ringSet.atomContainers()) {
            int len;
            if (!r.contains(this.atom) || (len = r.getAtomCount()) >= min) continue;
            min = len;
        }
        return min;
    }

    public boolean isQueryAtom() {
        return AtomRef.deref((IAtom)this.atom) instanceof IQueryAtom;
    }

    public OptionalInt getAtomToAtomMap() {
        Object atomAtomMapping = this.atom.getProperty((Object)"cdk:AtomAtomMapping");
        if (atomAtomMapping == null) {
            return OptionalInt.empty();
        }
        int value = 0;
        if (atomAtomMapping instanceof String) {
            value = Integer.parseInt((String)atomAtomMapping);
        } else if (atomAtomMapping instanceof Integer) {
            value = (Integer)atomAtomMapping;
        }
        if (value == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    public void setAtomToAtomMap(int value) {
        if (value == 0) {
            this.atom.removeProperty((Object)"cdk:AtomAtomMapping");
        } else {
            this.atom.setProperty((Object)"cdk:AtomAtomMapping", (Object)value);
        }
    }

    public boolean isInRing() {
        this.parent.ringsSearcherSupplier.get();
        return this.atom.isInRing();
    }

    public String getSymbol() {
        return this.atom.getSymbol();
    }

    public boolean isIsotope() {
        Integer mass = this.atom.getMassNumber();
        if (mass == null) {
            return false;
        }
        return !mass.equals(isotopeFactory.getMajorIsotope(this.atom.getSymbol()).getMassNumber());
    }

    public List<? extends Bond> getBonds() {
        return this.parent.getBondsFor(this.atom);
    }

    IAtom getAtom() {
        return this.atom;
    }

    public int getAtomicNumber() {
        return this.atom.getAtomicNumber();
    }

    public void setAtomicNumber(int atomicNumber) {
        this.atom.setAtomicNumber(Integer.valueOf(atomicNumber));
    }

    public boolean hasAromaticBond() {
        return this.atom.isAromatic();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.atom.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CdkAtom other = (CdkAtom)obj;
        return this.atom.equals(other.atom);
    }

    public int getCharge() {
        Integer charge = this.atom.getFormalCharge();
        if (charge == null || CDKConstants.UNSET == charge) {
            return 0;
        }
        return charge;
    }

    public int getRadical() {
        List list = this.parent.getContainer().getConnectedSingleElectronsList(this.atom);
        if (list.isEmpty()) {
            return 0;
        }
        return list.stream().map(ise -> ise.getElectronCount()).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
    }

    public void setRadical(int radical) {
        SingleElectron ise = new SingleElectron(this.atom);
        ise.setElectronCount(Integer.valueOf(radical));
        IAtomContainer container = this.parent.getContainer();
        container.getConnectedSingleElectronsList(this.atom).forEach(arg_0 -> ((IAtomContainer)container).removeSingleElectron(arg_0));
        container.addSingleElectron((ISingleElectron)ise);
    }

    public AtomCoordinates getAtomCoordinates() {
        Point3d points = this.atom.getPoint3d();
        if (points != null) {
            return AtomCoordinates.valueOf((double)points.x, (double)points.y, (double)points.z);
        }
        Point2d otherPoints = this.atom.getPoint2d();
        if (otherPoints != null) {
            return AtomCoordinates.valueOf((double)otherPoints.x, (double)otherPoints.y);
        }
        return null;
    }

    public void setAtomCoordinates(AtomCoordinates atomCoordinates) {
        if (atomCoordinates == null) {
            this.atom.setPoint2d(null);
            this.atom.setPoint3d(null);
        } else if (atomCoordinates.is3D()) {
            this.atom.setPoint2d(null);
            this.atom.setPoint3d(new Point3d(atomCoordinates.getX(), atomCoordinates.getY(), atomCoordinates.getZ().getAsDouble()));
        } else {
            this.atom.setPoint3d(null);
            this.atom.setPoint2d(new Point2d(atomCoordinates.getX(), atomCoordinates.getY()));
        }
    }

    public Chirality getChirality() {
        this.parent.cahnIngoldPrelogSupplier.get();
        String value = (String)this.atom.getProperty((Object)"cip.label");
        if ("R".equals(value)) {
            return Chirality.R;
        }
        if ("S".equals(value)) {
            return Chirality.S;
        }
        return Chirality.Non_Chiral;
    }

    public void setChirality(Chirality chirality) {
    }

    public int getMassNumber() {
        Integer num = this.atom.getMassNumber();
        if (num == null) {
            return 0;
        }
        return num;
    }

    public double getExactMass() {
        Double d = this.atom.getExactMass();
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public void setCharge(int charge) {
        this.atom.setFormalCharge(Integer.valueOf(charge));
        this.recomputeImplicitHydrogens();
    }

    private void recomputeImplicitHydrogens() {
        this.atom.setImplicitHydrogenCount(null);
        this.parent.setImplicitHydrogens(this.atom);
    }

    public void setMassNumber(int mass) {
        if (mass < 0) {
            throw new IllegalArgumentException("mass can not be negative");
        }
        if (mass == 0) {
            this.atom.setMassNumber(null);
        } else {
            this.atom.setMassNumber(Integer.valueOf(mass));
        }
        this.recomputeImplicitHydrogens();
    }

    public int getImplicitHCount() {
        Integer ret = this.atom.getImplicitHydrogenCount();
        if (ret == null) {
            if (this.isQueryAtom()) {
                return 0;
            }
            return this.parent.setImplicitHydrogens(this.atom);
        }
        return ret;
    }

    public void setImplicitHCount(Integer implicitH) {
        this.atom.setImplicitHydrogenCount(implicitH);
    }

    public int getRadicalValue() {
        return this.parent.getContainer().getConnectedSingleElectronsCount(this.atom);
    }

    public OptionalInt getValence() {
        this.parent.perceiveAtomTypesOfNonQueryAtoms.get();
        Integer valence = this.atom.getValency();
        if (valence == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(valence);
    }

    public boolean hasValenceError() {
        return !this.getValence().isPresent();
    }

    public boolean isRGroupAtom() {
        return this.getRGroupIndex().isPresent();
    }

    public OptionalInt getRGroupIndex() {
        return this.getPseudoAtomField(iPseudoAtom -> {
            String label = iPseudoAtom.getLabel();
            if (label != null && RGroupQuery.isValidRgroupQueryLabel((String)label)) {
                return OptionalInt.of(Integer.parseInt(label.substring(1)));
            }
            return OptionalInt.empty();
        }, OptionalInt::empty);
    }

    public void setRGroup(Integer rGroup) {
        if (rGroup == null || rGroup < 1) {
            if (this.isRGroupAtom()) {
                this.setAlias(null);
            }
        } else {
            this.setAlias("R" + rGroup);
        }
    }

    private <T> T getPseudoAtomField(Function<IPseudoAtom, T> function, Supplier<T> emptySupplier) {
        if (this.atom instanceof IPseudoAtom) {
            IPseudoAtom iPseudoAtom = (IPseudoAtom)this.atom;
            return function.apply(iPseudoAtom);
        }
        return emptySupplier.get();
    }

    public Optional<String> getAlias() {
        return this.getPseudoAtomField(a -> Optional.ofNullable(a.getLabel()), Optional::empty);
    }

    public void setAlias(String alias) {
        this.changeToPseudoAtomIfNeeded((pseudoAtom, newObj) -> {
            pseudoAtom.setLabel(alias);
            if (newObj.booleanValue()) {
                pseudoAtom.setSymbol(alias);
            }
        });
    }

    private void changeToPseudoAtomIfNeeded(BiConsumer<IPseudoAtom, Boolean> consumer) {
        IPseudoAtom pseudoAtom;
        IAtomContainer container = this.parent.getContainer();
        IPseudoAtom iPseudoAtom = pseudoAtom = this.atom instanceof IPseudoAtom ? (IPseudoAtom)this.atom : (IPseudoAtom)container.getBuilder().newInstance(IPseudoAtom.class, new Object[0]);
        if (this.atom.equals(pseudoAtom)) {
            consumer.accept(pseudoAtom, false);
        } else {
            pseudoAtom.setSymbol(this.atom.getSymbol());
            pseudoAtom.setAtomicNumber(Integer.valueOf(0));
            pseudoAtom.setPoint2d(this.atom.getPoint2d());
            pseudoAtom.setPoint3d(this.atom.getPoint3d());
            pseudoAtom.setMassNumber(this.atom.getMassNumber());
            pseudoAtom.setFormalCharge(this.atom.getFormalCharge());
            pseudoAtom.setValency(this.atom.getValency());
            consumer.accept(pseudoAtom, true);
            AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)container, (IAtom)this.atom, (IAtom)pseudoAtom);
            this.atom = pseudoAtom;
        }
    }

    public String toString() {
        return "CdkAtom [atom=" + this.atom + "]";
    }

    public int getAtomIndexInParent() {
        return this.atom.getIndex();
    }

    static {
        try {
            isotopeFactory = Isotopes.getInstance();
        }
        catch (IOException e) {
            throw new IllegalStateException("error loading isotope data", e);
        }
    }
}

