/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.exceptions.CorruptChecksumException;
import gov.loc.repository.bagit.hash.Hasher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckManifestHashesTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CheckManifestHashesTask.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    private final Map.Entry<Path, String> entry;
    private final CountDownLatch latch;
    private final List<Exception> exceptions;
    private final String algorithm;

    public CheckManifestHashesTask(Map.Entry<Path, String> entry, String algorithm, CountDownLatch latch, List<Exception> exceptions) {
        this.entry = entry;
        this.algorithm = algorithm;
        this.latch = latch;
        this.exceptions = exceptions;
    }

    @Override
    public void run() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
            CheckManifestHashesTask.checkManifestEntry(this.entry, messageDigest, this.algorithm);
        }
        catch (CorruptChecksumException | IOException | NoSuchAlgorithmException e) {
            this.exceptions.add(e);
        }
        this.latch.countDown();
    }

    protected static void checkManifestEntry(Map.Entry<Path, String> entry, MessageDigest messageDigest, String algorithm) throws IOException, CorruptChecksumException {
        if (Files.exists(entry.getKey(), new LinkOption[0])) {
            logger.debug(messages.getString("checking_checksums"), (Object)entry.getKey(), (Object)entry.getValue());
            String hash = Hasher.hash(entry.getKey(), messageDigest);
            logger.debug("computed hash [{}] for file [{}]", (Object)hash, (Object)entry.getKey());
            if (!hash.equals(entry.getValue())) {
                throw new CorruptChecksumException(messages.getString("corrupt_checksum_error"), entry.getKey(), algorithm, entry.getValue(), hash);
            }
        }
    }

    public Map.Entry<Path, String> getEntry() {
        return this.entry;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

