/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.util.PathUtils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPayloadFileExistsInManifestsVistor
extends SimpleFileVisitor<Path> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractPayloadFileExistsInManifestsVistor.class);
    protected static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    protected final boolean ignoreHiddenFiles;

    public AbstractPayloadFileExistsInManifestsVistor(boolean ignoreHiddenFiles) {
        this.ignoreHiddenFiles = ignoreHiddenFiles;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.ignoreHiddenFiles && PathUtils.isHidden(dir) || dir.endsWith(Paths.get(".bagit", new String[0]))) {
            logger.debug(messages.getString("skipping_hidden_file"), (Object)dir);
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    public boolean isIgnoreHiddenFiles() {
        return this.ignoreHiddenFiles;
    }
}

