/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.reader;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Version;
import gov.loc.repository.bagit.exceptions.InvalidBagMetadataException;
import gov.loc.repository.bagit.exceptions.InvalidBagitFileFormatException;
import gov.loc.repository.bagit.exceptions.MaliciousPathException;
import gov.loc.repository.bagit.exceptions.UnparsableVersionException;
import gov.loc.repository.bagit.exceptions.UnsupportedAlgorithmException;
import gov.loc.repository.bagit.hash.BagitAlgorithmNameToSupportedAlgorithmMapping;
import gov.loc.repository.bagit.hash.StandardBagitAlgorithmNameToSupportedAlgorithmMapping;
import gov.loc.repository.bagit.reader.BagitTextFileReader;
import gov.loc.repository.bagit.reader.FetchReader;
import gov.loc.repository.bagit.reader.ManifestReader;
import gov.loc.repository.bagit.reader.MetadataReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;

public final class BagReader {
    private final BagitAlgorithmNameToSupportedAlgorithmMapping nameMapping;

    public BagReader() {
        this.nameMapping = new StandardBagitAlgorithmNameToSupportedAlgorithmMapping();
    }

    public BagReader(BagitAlgorithmNameToSupportedAlgorithmMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    public Bag read(Path rootDir) throws IOException, UnparsableVersionException, MaliciousPathException, InvalidBagMetadataException, UnsupportedAlgorithmException, InvalidBagitFileFormatException {
        Bag bag = new Bag();
        Path bagitDir = rootDir.resolve(".bagit");
        if (!Files.exists(bagitDir, new LinkOption[0])) {
            bagitDir = rootDir;
        }
        bag.setRootDir(rootDir);
        Path bagitFile = bagitDir.resolve("bagit.txt");
        AbstractMap.SimpleImmutableEntry<Version, Charset> bagitInfo = BagitTextFileReader.readBagitTextFile(bagitFile);
        bag.setVersion(bagitInfo.getKey());
        bag.setFileEncoding(bagitInfo.getValue());
        ManifestReader.readAllManifests(this.nameMapping, bagitDir, bag);
        bag.getMetadata().addAll(MetadataReader.readBagMetadata(bagitDir, bag.getFileEncoding()));
        Path fetchFile = bagitDir.resolve("fetch.txt");
        if (Files.exists(fetchFile, new LinkOption[0])) {
            bag.getItemsToFetch().addAll(FetchReader.readFetch(fetchFile, bag.getFileEncoding(), bag.getRootDir()));
        }
        return bag;
    }

    public BagitAlgorithmNameToSupportedAlgorithmMapping getNameMapping() {
        return this.nameMapping;
    }
}

