/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer;

import gov.loc.repository.bagit.domain.Metadata;
import gov.loc.repository.bagit.domain.Version;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataWriter {
    private static final Logger logger = LoggerFactory.getLogger(MetadataWriter.class);
    private static final Version VERSION_0_95 = new Version(0, 95);

    private MetadataWriter() {
    }

    public static void writeBagMetadata(Metadata metadata, Version version, Path outputDir, Charset charsetName) throws IOException {
        Path bagInfoFilePath = outputDir.resolve("bag-info.txt");
        if (version.isSameOrOlder(VERSION_0_95)) {
            bagInfoFilePath = outputDir.resolve("package-info.txt");
        }
        logger.debug("Writing {} to [{}]", (Object)bagInfoFilePath.getFileName(), (Object)outputDir);
        Files.deleteIfExists(bagInfoFilePath);
        StringBuilder lines = new StringBuilder();
        for (AbstractMap.SimpleImmutableEntry<String, String> entry : metadata.getAll()) {
            String line = entry.getKey() + ": " + entry.getValue() + System.lineSeparator();
            lines.append(line);
        }
        logger.debug("Writing [{}] to [{}]", (Object)lines.toString(), (Object)bagInfoFilePath);
        Files.write(bagInfoFilePath, lines.toString().getBytes(charsetName), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }
}

