/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer;

import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.writer.PayloadWriter;
import gov.loc.repository.bagit.writer.RelativePathWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManifestWriter {
    private static final Logger logger = LoggerFactory.getLogger(PayloadWriter.class);

    private ManifestWriter() {
    }

    public static void writePayloadManifests(Set<Manifest> manifests, Path outputDir, Path bagitRootDir, Charset charsetName) throws IOException {
        logger.info("Writing payload manifest(s)");
        ManifestWriter.writeManifests(manifests, outputDir, bagitRootDir, "manifest-", charsetName);
    }

    public static void writeTagManifests(Set<Manifest> tagManifests, Path outputDir, Path bagitRootDir, Charset charsetName) throws IOException {
        logger.info("Writing tag manifest(s)");
        ManifestWriter.writeManifests(tagManifests, outputDir, bagitRootDir, "tagmanifest-", charsetName);
    }

    private static void writeManifests(Set<Manifest> manifests, Path outputDir, Path relativeTo, String filenameBase, Charset charsetName) throws IOException {
        for (Manifest manifest : manifests) {
            Path manifestPath = outputDir.resolve(filenameBase + manifest.getAlgorithm().getBagitName() + ".txt");
            logger.debug("Writing manifest to [{}]", (Object)manifestPath);
            Files.deleteIfExists(manifestPath);
            Files.createFile(manifestPath, new FileAttribute[0]);
            for (Map.Entry<Path, String> entry : manifest.getFileToChecksumMap().entrySet()) {
                String line = entry.getValue() + "  " + RelativePathWriter.formatRelativePathString(relativeTo, entry.getKey());
                logger.debug("Writing [{}] to [{}]", (Object)line, (Object)manifestPath);
                Files.write(manifestPath, line.getBytes(charsetName), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
        }
    }
}

