/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer;

import gov.loc.repository.bagit.domain.FetchItem;
import gov.loc.repository.bagit.writer.RelativePathWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FetchWriter {
    private static final Logger logger = LoggerFactory.getLogger(FetchWriter.class);

    private FetchWriter() {
    }

    public static void writeFetchFile(List<FetchItem> itemsToFetch, Path outputDir, Path bagitRootDir, Charset charsetName) throws IOException {
        logger.debug("Writing fetch.txt to [{}]", (Object)outputDir);
        Path fetchFilePath = outputDir.resolve("fetch.txt");
        for (FetchItem item : itemsToFetch) {
            String line = FetchWriter.formatFetchLine(item, bagitRootDir);
            logger.debug("Writing [{}] to [{}]", (Object)line, (Object)fetchFilePath);
            Files.write(fetchFilePath, line.getBytes(charsetName), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
    }

    private static String formatFetchLine(FetchItem fetchItem, Path bagitRootDir) {
        StringBuilder sb = new StringBuilder();
        sb.append(fetchItem.getUrl()).append(' ');
        if (fetchItem.getLength() == null || fetchItem.getLength() < 0L) {
            sb.append("- ");
        } else {
            sb.append(fetchItem.getLength()).append(' ');
        }
        sb.append(RelativePathWriter.formatRelativePathString(bagitRootDir, fetchItem.getPath()));
        return sb.toString();
    }
}

