/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.exceptions.InvalidPayloadOxumException;
import gov.loc.repository.bagit.exceptions.PayloadOxumDoesNotExistException;
import gov.loc.repository.bagit.util.PathUtils;
import gov.loc.repository.bagit.verify.FileCountAndTotalSizeVistor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuickVerifier {
    private static final Logger logger = LoggerFactory.getLogger(QuickVerifier.class);
    private static final String PAYLOAD_OXUM_REGEX = "\\d+\\.\\d+";

    private QuickVerifier() {
    }

    public static boolean canQuickVerify(Bag bag) {
        String payloadOxum = QuickVerifier.getPayloadOxum(bag);
        logger.debug("Found payload-oxum [{}] for bag [{}]", (Object)payloadOxum, (Object)bag.getRootDir());
        return payloadOxum != null && payloadOxum.matches(PAYLOAD_OXUM_REGEX) && bag.getItemsToFetch().size() == 0;
    }

    private static String getPayloadOxum(Bag bag) {
        for (AbstractMap.SimpleImmutableEntry<String, String> keyValue : bag.getMetadata().getAll()) {
            if (!"Payload-Oxum".equals(keyValue.getKey())) continue;
            return keyValue.getValue();
        }
        return null;
    }

    public static void quicklyVerify(Bag bag) throws IOException, InvalidPayloadOxumException {
        String payloadOxum = QuickVerifier.getPayloadOxum(bag);
        if (payloadOxum == null || !payloadOxum.matches(PAYLOAD_OXUM_REGEX)) {
            throw new PayloadOxumDoesNotExistException("Payload-Oxum does not exist in bag.");
        }
        String[] parts = payloadOxum.split("\\.");
        logger.debug("Parsing [{}] for the total byte size of the payload oxum", (Object)parts[0]);
        long totalSize = Long.parseLong(parts[0]);
        logger.debug("Parsing [{}] for the number of files to find in the payload directory", (Object)parts[1]);
        long numberOfFiles = Long.parseLong(parts[1]);
        Path payloadDir = PathUtils.getDataDir(bag);
        FileCountAndTotalSizeVistor vistor = new FileCountAndTotalSizeVistor();
        Files.walkFileTree(payloadDir, vistor);
        logger.info("supplied payload-oxum: [{}], Calculated payload-oxum: [{}.{}], for payload directory [{}]", new Object[]{payloadOxum, vistor.getTotalSize(), vistor.getCount(), payloadDir});
        if (totalSize != vistor.getTotalSize()) {
            throw new InvalidPayloadOxumException("Invalid total size. Expected " + totalSize + "but calculated " + vistor.getTotalSize());
        }
        if (numberOfFiles != vistor.getCount()) {
            throw new InvalidPayloadOxumException("Invalid file count. Expected " + numberOfFiles + "but found " + vistor.getCount() + " files");
        }
    }
}

