/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.FetchItem;
import gov.loc.repository.bagit.domain.Version;
import gov.loc.repository.bagit.exceptions.FileNotInPayloadDirectoryException;
import gov.loc.repository.bagit.exceptions.MissingBagitFileException;
import gov.loc.repository.bagit.exceptions.MissingPayloadDirectoryException;
import gov.loc.repository.bagit.exceptions.MissingPayloadManifestException;
import gov.loc.repository.bagit.util.PathUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MandatoryVerifier {
    private static final Logger logger = LoggerFactory.getLogger(MandatoryVerifier.class);
    private static final String DOT_BAGIT_DIR_NAME = ".bagit";

    private MandatoryVerifier() {
    }

    public static void checkFetchItemsExist(List<FetchItem> items, Path bagDir) throws FileNotInPayloadDirectoryException {
        logger.info("Checking if all [{}] items in fetch.txt exist in the [{}]", (Object)items.size(), (Object)bagDir);
        for (FetchItem item : items) {
            if (Files.exists(item.path, new LinkOption[0])) continue;
            throw new FileNotInPayloadDirectoryException("Fetch item " + item + " has not been fetched!");
        }
    }

    public static void checkBagitFileExists(Path rootDir, Version version) throws MissingBagitFileException {
        logger.info("Checking if bagit.txt file exists");
        Path bagitFile = rootDir.resolve("bagit.txt");
        if (version.isSameOrNewer(new Version(2, 0))) {
            bagitFile = rootDir.resolve(DOT_BAGIT_DIR_NAME + File.separator + "bagit.txt");
        }
        if (!Files.exists(bagitFile, new LinkOption[0])) {
            throw new MissingBagitFileException("File [" + bagitFile + "] should exist but it doesn't");
        }
    }

    public static void checkPayloadDirectoryExists(Bag bag) throws MissingPayloadDirectoryException {
        logger.info("Checking if special payload directory exists (only for version 0.97 and earlier)");
        Path dataDir = PathUtils.getDataDir(bag);
        if (!Files.exists(dataDir, new LinkOption[0])) {
            throw new MissingPayloadDirectoryException("File [" + dataDir + "] should exist but it doesn't");
        }
    }

    public static void checkIfAtLeastOnePayloadManifestsExist(Path rootDir, Version version) throws MissingPayloadManifestException, IOException {
        logger.info("Checking if there is at least one payload manifest in [{}]", (Object)rootDir);
        boolean hasAtLeastOneManifest = false;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(PathUtils.getBagitDir(version, rootDir));){
            for (Path path : directoryStream) {
                if (!PathUtils.getFilename(path).startsWith("manifest-")) continue;
                logger.debug("Found payload manifest file [{}]", (Object)path.getFileName());
                hasAtLeastOneManifest = true;
            }
        }
        if (!hasAtLeastOneManifest) {
            throw new MissingPayloadManifestException("Bag does not contain any payload manifest files");
        }
    }
}

