/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.util.PathUtils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCountAndTotalSizeVistor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(FileCountAndTotalSizeVistor.class);
    private transient long totalSize;
    private transient long count;

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (PathUtils.isHidden(dir) || dir.endsWith(Paths.get(".bagit", new String[0]))) {
            logger.debug("Skipping {} cause we ignore hidden directories", (Object)dir);
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        if (PathUtils.isHidden(path) && !path.endsWith(".keep")) {
            logger.debug("Skipping [{}] since we are ignoring hidden files", (Object)path);
        } else {
            ++this.count;
            long size = Files.size(path);
            logger.debug("File [{}] hash a size of [{}] bytes", (Object)path, (Object)size);
            this.totalSize += size;
        }
        return FileVisitResult.CONTINUE;
    }

    public long getCount() {
        return this.count;
    }

    public long getTotalSize() {
        return this.totalSize;
    }
}

