/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.exceptions.CorruptChecksumException;
import gov.loc.repository.bagit.hash.Hasher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckManifestHashsTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CheckManifestHashsTask.class);
    private final transient Map.Entry<Path, String> entry;
    private final transient CountDownLatch latch;
    private final transient List<Exception> exceptions;
    private final transient String algorithm;

    public CheckManifestHashsTask(Map.Entry<Path, String> entry, String algorithm, CountDownLatch latch, List<Exception> exceptions) {
        this.entry = entry;
        this.algorithm = algorithm;
        this.latch = latch;
        this.exceptions = exceptions;
    }

    @Override
    public void run() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
            CheckManifestHashsTask.checkManifestEntry(this.entry, messageDigest, this.algorithm);
        }
        catch (CorruptChecksumException | IOException | NoSuchAlgorithmException e) {
            this.exceptions.add(e);
        }
        this.latch.countDown();
    }

    protected static void checkManifestEntry(Map.Entry<Path, String> entry, MessageDigest messageDigest, String algorithm) throws IOException, CorruptChecksumException {
        if (Files.exists(entry.getKey(), new LinkOption[0])) {
            logger.debug("Checking file [{}] to see if checksum matches [{}]", (Object)entry.getKey(), (Object)entry.getValue());
            String hash = Hasher.hash(entry.getKey(), messageDigest);
            logger.debug("computed hash [{}] for file [{}]", (Object)hash, (Object)entry.getKey());
            if (!hash.equals(entry.getValue())) {
                throw new CorruptChecksumException("File [" + entry.getKey() + "] is suppose to have a " + algorithm + " hash of [" + entry.getValue() + "] but was computed [" + hash + "]");
            }
        }
    }
}

