/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.exceptions.CorruptChecksumException;
import gov.loc.repository.bagit.exceptions.FileNotInPayloadDirectoryException;
import gov.loc.repository.bagit.exceptions.InvalidBagitFileFormatException;
import gov.loc.repository.bagit.exceptions.InvalidPayloadOxumException;
import gov.loc.repository.bagit.exceptions.MaliciousPathException;
import gov.loc.repository.bagit.exceptions.MissingBagitFileException;
import gov.loc.repository.bagit.exceptions.MissingPayloadDirectoryException;
import gov.loc.repository.bagit.exceptions.MissingPayloadManifestException;
import gov.loc.repository.bagit.exceptions.UnsupportedAlgorithmException;
import gov.loc.repository.bagit.exceptions.VerificationException;
import gov.loc.repository.bagit.hash.BagitAlgorithmNameToSupportedAlgorithmMapping;
import gov.loc.repository.bagit.hash.StandardBagitAlgorithmNameToSupportedAlgorithmMapping;
import gov.loc.repository.bagit.verify.CheckManifestHashsTask;
import gov.loc.repository.bagit.verify.MandatoryVerifier;
import gov.loc.repository.bagit.verify.PayloadVerifier;
import gov.loc.repository.bagit.verify.QuickVerifier;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BagVerifier {
    private static final Logger logger = LoggerFactory.getLogger(BagVerifier.class);
    private final PayloadVerifier manifestVerifier;
    private final ExecutorService executor;

    public BagVerifier() {
        this(Executors.newCachedThreadPool(), new StandardBagitAlgorithmNameToSupportedAlgorithmMapping());
    }

    public BagVerifier(BagitAlgorithmNameToSupportedAlgorithmMapping nameMapping) {
        this(Executors.newCachedThreadPool(), nameMapping);
    }

    public BagVerifier(ExecutorService executor) {
        this(executor, new StandardBagitAlgorithmNameToSupportedAlgorithmMapping());
    }

    public BagVerifier(ExecutorService executor, BagitAlgorithmNameToSupportedAlgorithmMapping nameMapping) {
        this.manifestVerifier = new PayloadVerifier(nameMapping);
        this.executor = executor;
    }

    protected void finalize() throws Throwable {
        try {
            this.executor.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    public static boolean canQuickVerify(Bag bag) {
        return QuickVerifier.canQuickVerify(bag);
    }

    public static void quicklyVerify(Bag bag) throws IOException, InvalidPayloadOxumException {
        QuickVerifier.quicklyVerify(bag);
    }

    public void isValid(Bag bag, boolean ignoreHiddenFiles) throws IOException, MissingPayloadManifestException, MissingBagitFileException, MissingPayloadDirectoryException, FileNotInPayloadDirectoryException, InterruptedException, MaliciousPathException, CorruptChecksumException, VerificationException, UnsupportedAlgorithmException, InvalidBagitFileFormatException {
        logger.info("Checking if the bag with root directory [{}] is valid.", (Object)bag.getRootDir());
        this.isComplete(bag, ignoreHiddenFiles);
        logger.debug("Checking payload manifest(s) checksums");
        for (Manifest payloadManifest : bag.getPayLoadManifests()) {
            this.checkHashes(payloadManifest);
        }
        logger.debug("Checking tag manifest(s) checksums");
        for (Manifest tagManifest : bag.getTagManifests()) {
            this.checkHashes(tagManifest);
        }
    }

    void checkHashes(Manifest manifest) throws CorruptChecksumException, InterruptedException, VerificationException {
        CountDownLatch latch = new CountDownLatch(manifest.getFileToChecksumMap().size());
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Map.Entry<Path, String> entry : manifest.getFileToChecksumMap().entrySet()) {
            this.executor.execute(new CheckManifestHashsTask(entry, manifest.getAlgorithm().getMessageDigestName(), latch, exceptions));
        }
        latch.await();
        if (!exceptions.isEmpty()) {
            Exception e = (Exception)exceptions.get(0);
            if (e instanceof CorruptChecksumException) {
                logger.debug("[{}] errors occured. At least one of the errors is due to hashes not matching.", (Object)exceptions.size());
                throw (CorruptChecksumException)e;
            }
            throw new VerificationException(e);
        }
    }

    public void isComplete(Bag bag, boolean ignoreHiddenFiles) throws IOException, MissingPayloadManifestException, MissingBagitFileException, MissingPayloadDirectoryException, FileNotInPayloadDirectoryException, InterruptedException, MaliciousPathException, UnsupportedAlgorithmException, InvalidBagitFileFormatException {
        logger.info("Checking if the bag with root directory [{}] is complete.", (Object)bag.getRootDir());
        MandatoryVerifier.checkFetchItemsExist(bag.getItemsToFetch(), bag.getRootDir());
        MandatoryVerifier.checkBagitFileExists(bag.getRootDir(), bag.getVersion());
        MandatoryVerifier.checkPayloadDirectoryExists(bag);
        MandatoryVerifier.checkIfAtLeastOnePayloadManifestsExist(bag.getRootDir(), bag.getVersion());
        this.manifestVerifier.verifyPayload(bag, ignoreHiddenFiles);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public PayloadVerifier getManifestVerifier() {
        return this.manifestVerifier;
    }
}

