/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.reader;

import gov.loc.repository.bagit.domain.Version;
import gov.loc.repository.bagit.exceptions.InvalidBagMetadataException;
import gov.loc.repository.bagit.exceptions.InvalidBagitFileFormatException;
import gov.loc.repository.bagit.exceptions.UnparsableVersionException;
import gov.loc.repository.bagit.reader.KeyValueReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BagitTextFileReader {
    private static final Logger logger = LoggerFactory.getLogger(BagitTextFileReader.class);
    private static final byte[] BOM = new byte[]{-17, -69, -65};

    private BagitTextFileReader() {
    }

    public static AbstractMap.SimpleImmutableEntry<Version, Charset> readBagitTextFile(Path bagitFile) throws IOException, UnparsableVersionException, InvalidBagMetadataException, InvalidBagitFileFormatException {
        logger.debug("Reading [{}] for version and encoding", (Object)bagitFile);
        BagitTextFileReader.throwErrorIfByteOrderMarkIsPresent(bagitFile);
        List<AbstractMap.SimpleImmutableEntry<String, String>> pairs = KeyValueReader.readKeyValuesFromFile(bagitFile, ":", StandardCharsets.UTF_8);
        String version = null;
        Charset encoding = null;
        for (AbstractMap.SimpleImmutableEntry<String, String> pair : pairs) {
            if ("BagIt-Version".equals(pair.getKey())) {
                version = pair.getValue();
                logger.debug("BagIt-Version is [{}]", (Object)version);
            }
            if (!"Tag-File-Character-Encoding".equals(pair.getKey())) continue;
            encoding = Charset.forName(pair.getValue());
            logger.debug("Tag-File-Character-Encoding is [{}]", (Object)encoding);
        }
        if (version == null || encoding == null) {
            throw new InvalidBagitFileFormatException("bagit.txt MUST contain 'BagIt-Version' AND 'Tag-File-Character-Encoding' entries!");
        }
        return new AbstractMap.SimpleImmutableEntry<Version, Object>(BagitTextFileReader.parseVersion(version), encoding);
    }

    private static void throwErrorIfByteOrderMarkIsPresent(Path bagitFile) throws IOException, InvalidBagitFileFormatException {
        byte[] firstFewBytesInFile = Arrays.copyOfRange(Files.readAllBytes(bagitFile), 0, BOM.length);
        if (Arrays.equals(BOM, firstFewBytesInFile)) {
            throw new InvalidBagitFileFormatException("File [" + bagitFile + "] contains a byte order mark (BOM) which is not allowed by the bagit specification!");
        }
    }

    public static Version parseVersion(String version) throws UnparsableVersionException {
        if (!version.contains(".")) {
            throw new UnparsableVersionException("Version must be in format MAJOR.MINOR but was " + version);
        }
        String[] parts = version.split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        return new Version(major, minor);
    }
}

